/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbAsyncClient;
import software.amazon.awssdk.services.memorydb.internal.UserAgentUtils;
import software.amazon.awssdk.services.memorydb.model.ACL;
import software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse;

public class DescribeACLsPublisher
implements SdkPublisher<DescribeAcLsResponse> {
    private final MemoryDbAsyncClient client;
    private final DescribeAcLsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeACLsPublisher(MemoryDbAsyncClient client, DescribeAcLsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeACLsPublisher(MemoryDbAsyncClient client, DescribeAcLsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAcLsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAcLsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ACL> acLs() {
        Function<DescribeAcLsResponse, Iterator> getIterator = response -> {
            if (response != null && response.acLs() != null) {
                return response.acLs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeAcLsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeAcLsResponseFetcher
    implements AsyncPageFetcher<DescribeAcLsResponse> {
        private DescribeAcLsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAcLsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAcLsResponse> nextPage(DescribeAcLsResponse previousPage) {
            if (previousPage == null) {
                return DescribeACLsPublisher.this.client.describeACLs(DescribeACLsPublisher.this.firstRequest);
            }
            return DescribeACLsPublisher.this.client.describeACLs((DescribeAcLsRequest)((Object)DescribeACLsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

