/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbClient;
import software.amazon.awssdk.services.memorydb.internal.UserAgentUtils;
import software.amazon.awssdk.services.memorydb.model.ACL;
import software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse;

public class DescribeACLsIterable
implements SdkIterable<DescribeAcLsResponse> {
    private final MemoryDbClient client;
    private final DescribeAcLsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeACLsIterable(MemoryDbClient client, DescribeAcLsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeAcLsResponseFetcher();
    }

    public Iterator<DescribeAcLsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ACL> acLs() {
        Function<DescribeAcLsResponse, Iterator> getIterator = response -> {
            if (response != null && response.acLs() != null) {
                return response.acLs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAcLsResponseFetcher
    implements SyncPageFetcher<DescribeAcLsResponse> {
        private DescribeAcLsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAcLsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAcLsResponse nextPage(DescribeAcLsResponse previousPage) {
            if (previousPage == null) {
                return DescribeACLsIterable.this.client.describeACLs(DescribeACLsIterable.this.firstRequest);
            }
            return DescribeACLsIterable.this.client.describeACLs((DescribeAcLsRequest)((Object)DescribeACLsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

