/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbClient;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesResponse;
import software.amazon.awssdk.services.memorydb.model.ReservedNode;

public class DescribeReservedNodesIterable
implements SdkIterable<DescribeReservedNodesResponse> {
    private final MemoryDbClient client;
    private final DescribeReservedNodesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedNodesIterable(MemoryDbClient client, DescribeReservedNodesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedNodesResponseFetcher();
    }

    public Iterator<DescribeReservedNodesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReservedNode> reservedNodes() {
        Function<DescribeReservedNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedNodes() != null) {
                return response.reservedNodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeReservedNodesResponseFetcher
    implements SyncPageFetcher<DescribeReservedNodesResponse> {
        private DescribeReservedNodesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeReservedNodesResponse nextPage(DescribeReservedNodesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedNodesIterable.this.client.describeReservedNodes(DescribeReservedNodesIterable.this.firstRequest);
            }
            return DescribeReservedNodesIterable.this.client.describeReservedNodes((DescribeReservedNodesRequest)((Object)DescribeReservedNodesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

