/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.MemoryDbRequest;
import software.amazon.awssdk.services.memorydb.model.UserNameListInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAclRequest
extends MemoryDbRequest
implements ToCopyableBuilder<Builder, UpdateAclRequest> {
    private static final SdkField<String> ACL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ACLName").getter(UpdateAclRequest.getter(UpdateAclRequest::aclName)).setter(UpdateAclRequest.setter(Builder::aclName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACLName").build()}).build();
    private static final SdkField<List<String>> USER_NAMES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserNamesToAdd").getter(UpdateAclRequest.getter(UpdateAclRequest::userNamesToAdd)).setter(UpdateAclRequest.setter(Builder::userNamesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserNamesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> USER_NAMES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserNamesToRemove").getter(UpdateAclRequest.getter(UpdateAclRequest::userNamesToRemove)).setter(UpdateAclRequest.setter(Builder::userNamesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserNamesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACL_NAME_FIELD, USER_NAMES_TO_ADD_FIELD, USER_NAMES_TO_REMOVE_FIELD));
    private final String aclName;
    private final List<String> userNamesToAdd;
    private final List<String> userNamesToRemove;

    private UpdateAclRequest(BuilderImpl builder) {
        super(builder);
        this.aclName = builder.aclName;
        this.userNamesToAdd = builder.userNamesToAdd;
        this.userNamesToRemove = builder.userNamesToRemove;
    }

    public final String aclName() {
        return this.aclName;
    }

    public final boolean hasUserNamesToAdd() {
        return this.userNamesToAdd != null && !(this.userNamesToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> userNamesToAdd() {
        return this.userNamesToAdd;
    }

    public final boolean hasUserNamesToRemove() {
        return this.userNamesToRemove != null && !(this.userNamesToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> userNamesToRemove() {
        return this.userNamesToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.aclName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserNamesToAdd() ? this.userNamesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserNamesToRemove() ? this.userNamesToRemove() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAclRequest)) {
            return false;
        }
        UpdateAclRequest other = (UpdateAclRequest)((Object)obj);
        return Objects.equals(this.aclName(), other.aclName()) && this.hasUserNamesToAdd() == other.hasUserNamesToAdd() && Objects.equals(this.userNamesToAdd(), other.userNamesToAdd()) && this.hasUserNamesToRemove() == other.hasUserNamesToRemove() && Objects.equals(this.userNamesToRemove(), other.userNamesToRemove());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAclRequest").add("ACLName", (Object)this.aclName()).add("UserNamesToAdd", this.hasUserNamesToAdd() ? this.userNamesToAdd() : null).add("UserNamesToRemove", this.hasUserNamesToRemove() ? this.userNamesToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ACLName": {
                return Optional.ofNullable(clazz.cast(this.aclName()));
            }
            case "UserNamesToAdd": {
                return Optional.ofNullable(clazz.cast(this.userNamesToAdd()));
            }
            case "UserNamesToRemove": {
                return Optional.ofNullable(clazz.cast(this.userNamesToRemove()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAclRequest, T> g) {
        return obj -> g.apply((UpdateAclRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbRequest.BuilderImpl
    implements Builder {
        private String aclName;
        private List<String> userNamesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> userNamesToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAclRequest model) {
            super(model);
            this.aclName(model.aclName);
            this.userNamesToAdd(model.userNamesToAdd);
            this.userNamesToRemove(model.userNamesToRemove);
        }

        public final String getAclName() {
            return this.aclName;
        }

        public final void setAclName(String aclName) {
            this.aclName = aclName;
        }

        @Override
        @Transient
        public final Builder aclName(String aclName) {
            this.aclName = aclName;
            return this;
        }

        public final Collection<String> getUserNamesToAdd() {
            if (this.userNamesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userNamesToAdd;
        }

        public final void setUserNamesToAdd(Collection<String> userNamesToAdd) {
            this.userNamesToAdd = UserNameListInputCopier.copy(userNamesToAdd);
        }

        @Override
        @Transient
        public final Builder userNamesToAdd(Collection<String> userNamesToAdd) {
            this.userNamesToAdd = UserNameListInputCopier.copy(userNamesToAdd);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userNamesToAdd(String ... userNamesToAdd) {
            this.userNamesToAdd(Arrays.asList(userNamesToAdd));
            return this;
        }

        public final Collection<String> getUserNamesToRemove() {
            if (this.userNamesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userNamesToRemove;
        }

        public final void setUserNamesToRemove(Collection<String> userNamesToRemove) {
            this.userNamesToRemove = UserNameListInputCopier.copy(userNamesToRemove);
        }

        @Override
        @Transient
        public final Builder userNamesToRemove(Collection<String> userNamesToRemove) {
            this.userNamesToRemove = UserNameListInputCopier.copy(userNamesToRemove);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userNamesToRemove(String ... userNamesToRemove) {
            this.userNamesToRemove(Arrays.asList(userNamesToRemove));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAclRequest build() {
            return new UpdateAclRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MemoryDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAclRequest> {
        public Builder aclName(String var1);

        public Builder userNamesToAdd(Collection<String> var1);

        public Builder userNamesToAdd(String ... var1);

        public Builder userNamesToRemove(Collection<String> var1);

        public Builder userNamesToRemove(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

