/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.MemoryDbRequest;
import software.amazon.awssdk.services.memorydb.model.ParameterNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResetParameterGroupRequest
extends MemoryDbRequest
implements ToCopyableBuilder<Builder, ResetParameterGroupRequest> {
    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterGroupName").getter(ResetParameterGroupRequest.getter(ResetParameterGroupRequest::parameterGroupName)).setter(ResetParameterGroupRequest.setter(Builder::parameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build()}).build();
    private static final SdkField<Boolean> ALL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllParameters").getter(ResetParameterGroupRequest.getter(ResetParameterGroupRequest::allParameters)).setter(ResetParameterGroupRequest.setter(Builder::allParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllParameters").build()}).build();
    private static final SdkField<List<String>> PARAMETER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParameterNames").getter(ResetParameterGroupRequest.getter(ResetParameterGroupRequest::parameterNames)).setter(ResetParameterGroupRequest.setter(Builder::parameterNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_GROUP_NAME_FIELD, ALL_PARAMETERS_FIELD, PARAMETER_NAMES_FIELD));
    private final String parameterGroupName;
    private final Boolean allParameters;
    private final List<String> parameterNames;

    private ResetParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.parameterGroupName = builder.parameterGroupName;
        this.allParameters = builder.allParameters;
        this.parameterNames = builder.parameterNames;
    }

    public final String parameterGroupName() {
        return this.parameterGroupName;
    }

    public final Boolean allParameters() {
        return this.allParameters;
    }

    public final boolean hasParameterNames() {
        return this.parameterNames != null && !(this.parameterNames instanceof SdkAutoConstructList);
    }

    public final List<String> parameterNames() {
        return this.parameterNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.allParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterNames() ? this.parameterNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetParameterGroupRequest)) {
            return false;
        }
        ResetParameterGroupRequest other = (ResetParameterGroupRequest)((Object)obj);
        return Objects.equals(this.parameterGroupName(), other.parameterGroupName()) && Objects.equals(this.allParameters(), other.allParameters()) && this.hasParameterNames() == other.hasParameterNames() && Objects.equals(this.parameterNames(), other.parameterNames());
    }

    public final String toString() {
        return ToString.builder((String)"ResetParameterGroupRequest").add("ParameterGroupName", (Object)this.parameterGroupName()).add("AllParameters", (Object)this.allParameters()).add("ParameterNames", this.hasParameterNames() ? this.parameterNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.parameterGroupName()));
            }
            case "AllParameters": {
                return Optional.ofNullable(clazz.cast(this.allParameters()));
            }
            case "ParameterNames": {
                return Optional.ofNullable(clazz.cast(this.parameterNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResetParameterGroupRequest, T> g) {
        return obj -> g.apply((ResetParameterGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbRequest.BuilderImpl
    implements Builder {
        private String parameterGroupName;
        private Boolean allParameters;
        private List<String> parameterNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResetParameterGroupRequest model) {
            super(model);
            this.parameterGroupName(model.parameterGroupName);
            this.allParameters(model.allParameters);
            this.parameterNames(model.parameterNames);
        }

        public final String getParameterGroupName() {
            return this.parameterGroupName;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        @Override
        @Transient
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final Boolean getAllParameters() {
            return this.allParameters;
        }

        public final void setAllParameters(Boolean allParameters) {
            this.allParameters = allParameters;
        }

        @Override
        @Transient
        public final Builder allParameters(Boolean allParameters) {
            this.allParameters = allParameters;
            return this;
        }

        public final Collection<String> getParameterNames() {
            if (this.parameterNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.parameterNames;
        }

        public final void setParameterNames(Collection<String> parameterNames) {
            this.parameterNames = ParameterNameListCopier.copy(parameterNames);
        }

        @Override
        @Transient
        public final Builder parameterNames(Collection<String> parameterNames) {
            this.parameterNames = ParameterNameListCopier.copy(parameterNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parameterNames(String ... parameterNames) {
            this.parameterNames(Arrays.asList(parameterNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetParameterGroupRequest build() {
            return new ResetParameterGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MemoryDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResetParameterGroupRequest> {
        public Builder parameterGroupName(String var1);

        public Builder allParameters(Boolean var1);

        public Builder parameterNames(Collection<String> var1);

        public Builder parameterNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

