/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediatailor.model.AudiencesCopier;
import software.amazon.awssdk.services.mediatailor.model.LogConfigurationForChannel;
import software.amazon.awssdk.services.mediatailor.model.ResponseOutputItem;
import software.amazon.awssdk.services.mediatailor.model.ResponseOutputsCopier;
import software.amazon.awssdk.services.mediatailor.model.SlateSource;
import software.amazon.awssdk.services.mediatailor.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Channel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Channel> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Channel.getter(Channel::arn)).setter(Channel.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<List<String>> AUDIENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Audiences").getter(Channel.getter(Channel::audiences)).setter(Channel.setter(Builder::audiences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audiences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(Channel.getter(Channel::channelName)).setter(Channel.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<String> CHANNEL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelState").getter(Channel.getter(Channel::channelState)).setter(Channel.setter(Builder::channelState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelState").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Channel.getter(Channel::creationTime)).setter(Channel.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<SlateSource> FILLER_SLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FillerSlate").getter(Channel.getter(Channel::fillerSlate)).setter(Channel.setter(Builder::fillerSlate)).constructor(SlateSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FillerSlate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(Channel.getter(Channel::lastModifiedTime)).setter(Channel.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<LogConfigurationForChannel> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogConfiguration").getter(Channel.getter(Channel::logConfiguration)).setter(Channel.setter(Builder::logConfiguration)).constructor(LogConfigurationForChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()}).build();
    private static final SdkField<List<ResponseOutputItem>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Outputs").getter(Channel.getter(Channel::outputs)).setter(Channel.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResponseOutputItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLAYBACK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaybackMode").getter(Channel.getter(Channel::playbackMode)).setter(Channel.setter(Builder::playbackMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackMode").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Channel.getter(Channel::tags)).setter(Channel.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(Channel.getter(Channel::tier)).setter(Channel.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AUDIENCES_FIELD, CHANNEL_NAME_FIELD, CHANNEL_STATE_FIELD, CREATION_TIME_FIELD, FILLER_SLATE_FIELD, LAST_MODIFIED_TIME_FIELD, LOG_CONFIGURATION_FIELD, OUTPUTS_FIELD, PLAYBACK_MODE_FIELD, TAGS_FIELD, TIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<String> audiences;
    private final String channelName;
    private final String channelState;
    private final Instant creationTime;
    private final SlateSource fillerSlate;
    private final Instant lastModifiedTime;
    private final LogConfigurationForChannel logConfiguration;
    private final List<ResponseOutputItem> outputs;
    private final String playbackMode;
    private final Map<String, String> tags;
    private final String tier;

    private Channel(BuilderImpl builder) {
        this.arn = builder.arn;
        this.audiences = builder.audiences;
        this.channelName = builder.channelName;
        this.channelState = builder.channelState;
        this.creationTime = builder.creationTime;
        this.fillerSlate = builder.fillerSlate;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.logConfiguration = builder.logConfiguration;
        this.outputs = builder.outputs;
        this.playbackMode = builder.playbackMode;
        this.tags = builder.tags;
        this.tier = builder.tier;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasAudiences() {
        return this.audiences != null && !(this.audiences instanceof SdkAutoConstructList);
    }

    public final List<String> audiences() {
        return this.audiences;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String channelState() {
        return this.channelState;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final SlateSource fillerSlate() {
        return this.fillerSlate;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final LogConfigurationForChannel logConfiguration() {
        return this.logConfiguration;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<ResponseOutputItem> outputs() {
        return this.outputs;
    }

    public final String playbackMode() {
        return this.playbackMode;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String tier() {
        return this.tier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudiences() ? this.audiences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelState());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fillerSlate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)obj;
        return Objects.equals(this.arn(), other.arn()) && this.hasAudiences() == other.hasAudiences() && Objects.equals(this.audiences(), other.audiences()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.channelState(), other.channelState()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.fillerSlate(), other.fillerSlate()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.logConfiguration(), other.logConfiguration()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.playbackMode(), other.playbackMode()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.tier(), other.tier());
    }

    public final String toString() {
        return ToString.builder((String)"Channel").add("Arn", (Object)this.arn()).add("Audiences", this.hasAudiences() ? this.audiences() : null).add("ChannelName", (Object)this.channelName()).add("ChannelState", (Object)this.channelState()).add("CreationTime", (Object)this.creationTime()).add("FillerSlate", (Object)this.fillerSlate()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LogConfiguration", (Object)this.logConfiguration()).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("PlaybackMode", (Object)this.playbackMode()).add("Tags", this.hasTags() ? this.tags() : null).add("Tier", (Object)this.tier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Audiences": {
                return Optional.ofNullable(clazz.cast(this.audiences()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "ChannelState": {
                return Optional.ofNullable(clazz.cast(this.channelState()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FillerSlate": {
                return Optional.ofNullable(clazz.cast(this.fillerSlate()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "PlaybackMode": {
                return Optional.ofNullable(clazz.cast(this.playbackMode()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Channel, T> g) {
        return obj -> g.apply((Channel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<String> audiences = DefaultSdkAutoConstructList.getInstance();
        private String channelName;
        private String channelState;
        private Instant creationTime;
        private SlateSource fillerSlate;
        private Instant lastModifiedTime;
        private LogConfigurationForChannel logConfiguration;
        private List<ResponseOutputItem> outputs = DefaultSdkAutoConstructList.getInstance();
        private String playbackMode;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String tier;

        private BuilderImpl() {
        }

        private BuilderImpl(Channel model) {
            this.arn(model.arn);
            this.audiences(model.audiences);
            this.channelName(model.channelName);
            this.channelState(model.channelState);
            this.creationTime(model.creationTime);
            this.fillerSlate(model.fillerSlate);
            this.lastModifiedTime(model.lastModifiedTime);
            this.logConfiguration(model.logConfiguration);
            this.outputs(model.outputs);
            this.playbackMode(model.playbackMode);
            this.tags(model.tags);
            this.tier(model.tier);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAudiences() {
            if (this.audiences instanceof SdkAutoConstructList) {
                return null;
            }
            return this.audiences;
        }

        public final void setAudiences(Collection<String> audiences) {
            this.audiences = AudiencesCopier.copy(audiences);
        }

        @Override
        public final Builder audiences(Collection<String> audiences) {
            this.audiences = AudiencesCopier.copy(audiences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audiences(String ... audiences) {
            this.audiences(Arrays.asList(audiences));
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getChannelState() {
            return this.channelState;
        }

        public final void setChannelState(String channelState) {
            this.channelState = channelState;
        }

        @Override
        public final Builder channelState(String channelState) {
            this.channelState = channelState;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final SlateSource.Builder getFillerSlate() {
            return this.fillerSlate != null ? this.fillerSlate.toBuilder() : null;
        }

        public final void setFillerSlate(SlateSource.BuilderImpl fillerSlate) {
            this.fillerSlate = fillerSlate != null ? fillerSlate.build() : null;
        }

        @Override
        public final Builder fillerSlate(SlateSource fillerSlate) {
            this.fillerSlate = fillerSlate;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final LogConfigurationForChannel.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfigurationForChannel.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfigurationForChannel logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final List<ResponseOutputItem.Builder> getOutputs() {
            List<ResponseOutputItem.Builder> result = ResponseOutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<ResponseOutputItem.BuilderImpl> outputs) {
            this.outputs = ResponseOutputsCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<ResponseOutputItem> outputs) {
            this.outputs = ResponseOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(ResponseOutputItem ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<ResponseOutputItem.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (ResponseOutputItem)((ResponseOutputItem.Builder)ResponseOutputItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPlaybackMode() {
            return this.playbackMode;
        }

        public final void setPlaybackMode(String playbackMode) {
            this.playbackMode = playbackMode;
        }

        @Override
        public final Builder playbackMode(String playbackMode) {
            this.playbackMode = playbackMode;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        public Channel build() {
            return new Channel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Channel> {
        public Builder arn(String var1);

        public Builder audiences(Collection<String> var1);

        public Builder audiences(String ... var1);

        public Builder channelName(String var1);

        public Builder channelState(String var1);

        public Builder creationTime(Instant var1);

        public Builder fillerSlate(SlateSource var1);

        default public Builder fillerSlate(Consumer<SlateSource.Builder> fillerSlate) {
            return this.fillerSlate((SlateSource)((SlateSource.Builder)SlateSource.builder().applyMutation(fillerSlate)).build());
        }

        public Builder lastModifiedTime(Instant var1);

        public Builder logConfiguration(LogConfigurationForChannel var1);

        default public Builder logConfiguration(Consumer<LogConfigurationForChannel.Builder> logConfiguration) {
            return this.logConfiguration((LogConfigurationForChannel)((LogConfigurationForChannel.Builder)LogConfigurationForChannel.builder().applyMutation(logConfiguration)).build());
        }

        public Builder outputs(Collection<ResponseOutputItem> var1);

        public Builder outputs(ResponseOutputItem ... var1);

        public Builder outputs(Consumer<ResponseOutputItem.Builder> ... var1);

        public Builder playbackMode(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder tier(String var1);
    }
}

