/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SlateSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SlateSource> {
    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceLocationName").getter(SlateSource.getter(SlateSource::sourceLocationName)).setter(SlateSource.setter(Builder::sourceLocationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationName").build()}).build();
    private static final SdkField<String> VOD_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VodSourceName").getter(SlateSource.getter(SlateSource::vodSourceName)).setter(SlateSource.setter(Builder::vodSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VodSourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_LOCATION_NAME_FIELD, VOD_SOURCE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceLocationName;
    private final String vodSourceName;

    private SlateSource(BuilderImpl builder) {
        this.sourceLocationName = builder.sourceLocationName;
        this.vodSourceName = builder.vodSourceName;
    }

    public final String sourceLocationName() {
        return this.sourceLocationName;
    }

    public final String vodSourceName() {
        return this.vodSourceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vodSourceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlateSource)) {
            return false;
        }
        SlateSource other = (SlateSource)obj;
        return Objects.equals(this.sourceLocationName(), other.sourceLocationName()) && Objects.equals(this.vodSourceName(), other.vodSourceName());
    }

    public final String toString() {
        return ToString.builder((String)"SlateSource").add("SourceLocationName", (Object)this.sourceLocationName()).add("VodSourceName", (Object)this.vodSourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceLocationName": {
                return Optional.ofNullable(clazz.cast(this.sourceLocationName()));
            }
            case "VodSourceName": {
                return Optional.ofNullable(clazz.cast(this.vodSourceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlateSource, T> g) {
        return obj -> g.apply((SlateSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceLocationName;
        private String vodSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(SlateSource model) {
            this.sourceLocationName(model.sourceLocationName);
            this.vodSourceName(model.vodSourceName);
        }

        public final String getSourceLocationName() {
            return this.sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        public final String getVodSourceName() {
            return this.vodSourceName;
        }

        @Override
        public final Builder vodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
            return this;
        }

        public final void setVodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
        }

        public SlateSource build() {
            return new SlateSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SlateSource> {
        public Builder sourceLocationName(String var1);

        public Builder vodSourceName(String var1);
    }
}

