/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediastore.model.CorsPolicyCopier;
import software.amazon.awssdk.services.mediastore.model.CorsRule;
import software.amazon.awssdk.services.mediastore.model.MediaStoreResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCorsPolicyResponse
extends MediaStoreResponse
implements ToCopyableBuilder<Builder, GetCorsPolicyResponse> {
    private static final SdkField<List<CorsRule>> CORS_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CorsPolicy").getter(GetCorsPolicyResponse.getter(GetCorsPolicyResponse::corsPolicy)).setter(GetCorsPolicyResponse.setter(Builder::corsPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CorsPolicy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CorsRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORS_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCorsPolicyResponse.memberNameToFieldInitializer();
    private final List<CorsRule> corsPolicy;

    private GetCorsPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.corsPolicy = builder.corsPolicy;
    }

    public final boolean hasCorsPolicy() {
        return this.corsPolicy != null && !(this.corsPolicy instanceof SdkAutoConstructList);
    }

    public final List<CorsRule> corsPolicy() {
        return this.corsPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCorsPolicy() ? this.corsPolicy() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCorsPolicyResponse)) {
            return false;
        }
        GetCorsPolicyResponse other = (GetCorsPolicyResponse)((Object)obj);
        return this.hasCorsPolicy() == other.hasCorsPolicy() && Objects.equals(this.corsPolicy(), other.corsPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"GetCorsPolicyResponse").add("CorsPolicy", this.hasCorsPolicy() ? this.corsPolicy() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CorsPolicy": {
                return Optional.ofNullable(clazz.cast(this.corsPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<CorsRule>>> map = new HashMap<String, SdkField<List<CorsRule>>>();
        map.put("CorsPolicy", CORS_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCorsPolicyResponse, T> g) {
        return obj -> g.apply((GetCorsPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaStoreResponse.BuilderImpl
    implements Builder {
        private List<CorsRule> corsPolicy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCorsPolicyResponse model) {
            super(model);
            this.corsPolicy(model.corsPolicy);
        }

        public final List<CorsRule.Builder> getCorsPolicy() {
            List<CorsRule.Builder> result = CorsPolicyCopier.copyToBuilder(this.corsPolicy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCorsPolicy(Collection<CorsRule.BuilderImpl> corsPolicy) {
            this.corsPolicy = CorsPolicyCopier.copyFromBuilder(corsPolicy);
        }

        @Override
        public final Builder corsPolicy(Collection<CorsRule> corsPolicy) {
            this.corsPolicy = CorsPolicyCopier.copy(corsPolicy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder corsPolicy(CorsRule ... corsPolicy) {
            this.corsPolicy(Arrays.asList(corsPolicy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder corsPolicy(Consumer<CorsRule.Builder> ... corsPolicy) {
            this.corsPolicy(Stream.of(corsPolicy).map(c -> (CorsRule)((CorsRule.Builder)CorsRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetCorsPolicyResponse build() {
            return new GetCorsPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaStoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCorsPolicyResponse> {
        public Builder corsPolicy(Collection<CorsRule> var1);

        public Builder corsPolicy(CorsRule ... var1);

        public Builder corsPolicy(Consumer<CorsRule.Builder> ... var1);
    }
}

