/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediastore.DefaultMediaStoreBaseClientBuilder;
import software.amazon.awssdk.services.mediastore.DefaultMediaStoreClient;
import software.amazon.awssdk.services.mediastore.MediaStoreClient;
import software.amazon.awssdk.services.mediastore.MediaStoreClientBuilder;
import software.amazon.awssdk.services.mediastore.MediaStoreServiceClientConfiguration;
import software.amazon.awssdk.services.mediastore.endpoints.MediaStoreEndpointProvider;

@SdkInternalApi
final class DefaultMediaStoreClientBuilder
extends DefaultMediaStoreBaseClientBuilder<MediaStoreClientBuilder, MediaStoreClient>
implements MediaStoreClientBuilder {
    DefaultMediaStoreClientBuilder() {
    }

    @Override
    public DefaultMediaStoreClientBuilder endpointProvider(MediaStoreEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaStoreClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultMediaStoreClientBuilder.validateClientOptions(clientConfiguration);
        MediaStoreServiceClientConfiguration serviceClientConfiguration = MediaStoreServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultMediaStoreClient(serviceClientConfiguration, clientConfiguration);
    }
}

