/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediastore.DefaultMediaStoreBaseClientBuilder;
import software.amazon.awssdk.services.mediastore.DefaultMediaStoreClient;
import software.amazon.awssdk.services.mediastore.MediaStoreClient;
import software.amazon.awssdk.services.mediastore.MediaStoreClientBuilder;
import software.amazon.awssdk.services.mediastore.MediaStoreServiceClientConfiguration;
import software.amazon.awssdk.services.mediastore.endpoints.MediaStoreEndpointProvider;

@SdkInternalApi
final class DefaultMediaStoreClientBuilder
extends DefaultMediaStoreBaseClientBuilder<MediaStoreClientBuilder, MediaStoreClient>
implements MediaStoreClientBuilder {
    DefaultMediaStoreClientBuilder() {
    }

    @Override
    public DefaultMediaStoreClientBuilder endpointProvider(MediaStoreEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaStoreClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultMediaStoreClientBuilder.validateClientOptions(clientConfiguration);
        MediaStoreServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMediaStoreClient client = new DefaultMediaStoreClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MediaStoreServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MediaStoreServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

