/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediastore.model.CorsPolicyCopier;
import software.amazon.awssdk.services.mediastore.model.CorsRule;
import software.amazon.awssdk.services.mediastore.model.MediaStoreRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutCorsPolicyRequest
extends MediaStoreRequest
implements ToCopyableBuilder<Builder, PutCorsPolicyRequest> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerName").getter(PutCorsPolicyRequest.getter(PutCorsPolicyRequest::containerName)).setter(PutCorsPolicyRequest.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerName").build()}).build();
    private static final SdkField<List<CorsRule>> CORS_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CorsPolicy").getter(PutCorsPolicyRequest.getter(PutCorsPolicyRequest::corsPolicy)).setter(PutCorsPolicyRequest.setter(Builder::corsPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CorsPolicy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CorsRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD, CORS_POLICY_FIELD));
    private final String containerName;
    private final List<CorsRule> corsPolicy;

    private PutCorsPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.containerName = builder.containerName;
        this.corsPolicy = builder.corsPolicy;
    }

    public final String containerName() {
        return this.containerName;
    }

    public final boolean hasCorsPolicy() {
        return this.corsPolicy != null && !(this.corsPolicy instanceof SdkAutoConstructList);
    }

    public final List<CorsRule> corsPolicy() {
        return this.corsPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCorsPolicy() ? this.corsPolicy() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutCorsPolicyRequest)) {
            return false;
        }
        PutCorsPolicyRequest other = (PutCorsPolicyRequest)((Object)obj);
        return Objects.equals(this.containerName(), other.containerName()) && this.hasCorsPolicy() == other.hasCorsPolicy() && Objects.equals(this.corsPolicy(), other.corsPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"PutCorsPolicyRequest").add("ContainerName", (Object)this.containerName()).add("CorsPolicy", this.hasCorsPolicy() ? this.corsPolicy() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "CorsPolicy": {
                return Optional.ofNullable(clazz.cast(this.corsPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutCorsPolicyRequest, T> g) {
        return obj -> g.apply((PutCorsPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaStoreRequest.BuilderImpl
    implements Builder {
        private String containerName;
        private List<CorsRule> corsPolicy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutCorsPolicyRequest model) {
            super(model);
            this.containerName(model.containerName);
            this.corsPolicy(model.corsPolicy);
        }

        public final String getContainerName() {
            return this.containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public final List<CorsRule.Builder> getCorsPolicy() {
            List<CorsRule.Builder> result = CorsPolicyCopier.copyToBuilder(this.corsPolicy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder corsPolicy(Collection<CorsRule> corsPolicy) {
            this.corsPolicy = CorsPolicyCopier.copy(corsPolicy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder corsPolicy(CorsRule ... corsPolicy) {
            this.corsPolicy(Arrays.asList(corsPolicy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder corsPolicy(Consumer<CorsRule.Builder> ... corsPolicy) {
            this.corsPolicy(Stream.of(corsPolicy).map(c -> (CorsRule)((CorsRule.Builder)CorsRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCorsPolicy(Collection<CorsRule.BuilderImpl> corsPolicy) {
            this.corsPolicy = CorsPolicyCopier.copyFromBuilder(corsPolicy);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutCorsPolicyRequest build() {
            return new PutCorsPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaStoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutCorsPolicyRequest> {
        public Builder containerName(String var1);

        public Builder corsPolicy(Collection<CorsRule> var1);

        public Builder corsPolicy(CorsRule ... var1);

        public Builder corsPolicy(Consumer<CorsRule.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

