/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MethodName {
    PUT("PUT"),
    GET("GET"),
    DELETE("DELETE"),
    HEAD("HEAD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MethodName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MethodName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MethodName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MethodName> knownValues() {
        return Stream.of(MethodName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

