/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediastore.MediaStoreClient;
import software.amazon.awssdk.services.mediastore.model.ListContainersRequest;
import software.amazon.awssdk.services.mediastore.model.ListContainersResponse;

public class ListContainersIterable
implements SdkIterable<ListContainersResponse> {
    private final MediaStoreClient client;
    private final ListContainersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContainersIterable(MediaStoreClient client, ListContainersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListContainersResponseFetcher();
    }

    public Iterator<ListContainersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListContainersResponseFetcher
    implements SyncPageFetcher<ListContainersResponse> {
        private ListContainersResponseFetcher() {
        }

        public boolean hasNextPage(ListContainersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContainersResponse nextPage(ListContainersResponse previousPage) {
            if (previousPage == null) {
                return ListContainersIterable.this.client.listContainers(ListContainersIterable.this.firstRequest);
            }
            return ListContainersIterable.this.client.listContainers((ListContainersRequest)((Object)ListContainersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

