/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricPolicyRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricPolicyRule> {
    private static final SdkField<String> OBJECT_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MetricPolicyRule.getter(MetricPolicyRule::objectGroup)).setter(MetricPolicyRule.setter(Builder::objectGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectGroup").build()}).build();
    private static final SdkField<String> OBJECT_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MetricPolicyRule.getter(MetricPolicyRule::objectGroupName)).setter(MetricPolicyRule.setter(Builder::objectGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_GROUP_FIELD, OBJECT_GROUP_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String objectGroup;
    private final String objectGroupName;

    private MetricPolicyRule(BuilderImpl builder) {
        this.objectGroup = builder.objectGroup;
        this.objectGroupName = builder.objectGroupName;
    }

    public String objectGroup() {
        return this.objectGroup;
    }

    public String objectGroupName() {
        return this.objectGroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objectGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectGroupName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricPolicyRule)) {
            return false;
        }
        MetricPolicyRule other = (MetricPolicyRule)obj;
        return Objects.equals(this.objectGroup(), other.objectGroup()) && Objects.equals(this.objectGroupName(), other.objectGroupName());
    }

    public String toString() {
        return ToString.builder((String)"MetricPolicyRule").add("ObjectGroup", (Object)this.objectGroup()).add("ObjectGroupName", (Object)this.objectGroupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectGroup": {
                return Optional.ofNullable(clazz.cast(this.objectGroup()));
            }
            case "ObjectGroupName": {
                return Optional.ofNullable(clazz.cast(this.objectGroupName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricPolicyRule, T> g) {
        return obj -> g.apply((MetricPolicyRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String objectGroup;
        private String objectGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricPolicyRule model) {
            this.objectGroup(model.objectGroup);
            this.objectGroupName(model.objectGroupName);
        }

        public final String getObjectGroup() {
            return this.objectGroup;
        }

        @Override
        public final Builder objectGroup(String objectGroup) {
            this.objectGroup = objectGroup;
            return this;
        }

        public final void setObjectGroup(String objectGroup) {
            this.objectGroup = objectGroup;
        }

        public final String getObjectGroupName() {
            return this.objectGroupName;
        }

        @Override
        public final Builder objectGroupName(String objectGroupName) {
            this.objectGroupName = objectGroupName;
            return this;
        }

        public final void setObjectGroupName(String objectGroupName) {
            this.objectGroupName = objectGroupName;
        }

        public MetricPolicyRule build() {
            return new MetricPolicyRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricPolicyRule> {
        public Builder objectGroup(String var1);

        public Builder objectGroupName(String var1);
    }
}

