/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mediapackagevod.model.DashEncryption;
import software.amazon.awssdk.services.mediapackagevod.model.DashManifest;
import software.amazon.awssdk.services.mediapackagevod.model.___listOfDashManifestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashPackage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashPackage> {
    private static final SdkField<List<DashManifest>> DASH_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DashPackage.getter(DashPackage::dashManifests)).setter(DashPackage.setter(Builder::dashManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DashManifest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DashEncryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DashPackage.getter(DashPackage::encryption)).setter(DashPackage.setter(Builder::encryption)).constructor(DashEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DashPackage.getter(DashPackage::segmentDurationSeconds)).setter(DashPackage.setter(Builder::segmentDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASH_MANIFESTS_FIELD, ENCRYPTION_FIELD, SEGMENT_DURATION_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<DashManifest> dashManifests;
    private final DashEncryption encryption;
    private final Integer segmentDurationSeconds;

    private DashPackage(BuilderImpl builder) {
        this.dashManifests = builder.dashManifests;
        this.encryption = builder.encryption;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
    }

    public List<DashManifest> dashManifests() {
        return this.dashManifests;
    }

    public DashEncryption encryption() {
        return this.encryption;
    }

    public Integer segmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dashManifests());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDurationSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashPackage)) {
            return false;
        }
        DashPackage other = (DashPackage)obj;
        return Objects.equals(this.dashManifests(), other.dashManifests()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.segmentDurationSeconds(), other.segmentDurationSeconds());
    }

    public String toString() {
        return ToString.builder((String)"DashPackage").add("DashManifests", this.dashManifests()).add("Encryption", (Object)this.encryption()).add("SegmentDurationSeconds", (Object)this.segmentDurationSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashManifests": {
                return Optional.ofNullable(clazz.cast(this.dashManifests()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "SegmentDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.segmentDurationSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashPackage, T> g) {
        return obj -> g.apply((DashPackage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DashManifest> dashManifests = DefaultSdkAutoConstructList.getInstance();
        private DashEncryption encryption;
        private Integer segmentDurationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(DashPackage model) {
            this.dashManifests(model.dashManifests);
            this.encryption(model.encryption);
            this.segmentDurationSeconds(model.segmentDurationSeconds);
        }

        public final Collection<DashManifest.Builder> getDashManifests() {
            return this.dashManifests != null ? (Collection)this.dashManifests.stream().map(DashManifest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dashManifests(Collection<DashManifest> dashManifests) {
            this.dashManifests = ___listOfDashManifestCopier.copy(dashManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(DashManifest ... dashManifests) {
            this.dashManifests(Arrays.asList(dashManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(Consumer<DashManifest.Builder> ... dashManifests) {
            this.dashManifests(Stream.of(dashManifests).map(c -> (DashManifest)((DashManifest.Builder)DashManifest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDashManifests(Collection<DashManifest.BuilderImpl> dashManifests) {
            this.dashManifests = ___listOfDashManifestCopier.copyFromBuilder(dashManifests);
        }

        public final DashEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(DashEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(DashEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Integer getSegmentDurationSeconds() {
            return this.segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public DashPackage build() {
            return new DashPackage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashPackage> {
        public Builder dashManifests(Collection<DashManifest> var1);

        public Builder dashManifests(DashManifest ... var1);

        public Builder dashManifests(Consumer<DashManifest.Builder> ... var1);

        public Builder encryption(DashEncryption var1);

        default public Builder encryption(Consumer<DashEncryption.Builder> encryption) {
            return this.encryption((DashEncryption)((DashEncryption.Builder)DashEncryption.builder().applyMutation(encryption)).build());
        }

        public Builder segmentDurationSeconds(Integer var1);
    }
}

