/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mediapackagevod.model.CmafEncryption;
import software.amazon.awssdk.services.mediapackagevod.model.HlsManifest;
import software.amazon.awssdk.services.mediapackagevod.model.___listOfHlsManifestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CmafPackage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CmafPackage> {
    private static final SdkField<CmafEncryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CmafPackage.getter(CmafPackage::encryption)).setter(CmafPackage.setter(Builder::encryption)).constructor(CmafEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<List<HlsManifest>> HLS_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CmafPackage.getter(CmafPackage::hlsManifests)).setter(CmafPackage.setter(Builder::hlsManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HlsManifest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CmafPackage.getter(CmafPackage::segmentDurationSeconds)).setter(CmafPackage.setter(Builder::segmentDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_FIELD, HLS_MANIFESTS_FIELD, SEGMENT_DURATION_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final CmafEncryption encryption;
    private final List<HlsManifest> hlsManifests;
    private final Integer segmentDurationSeconds;

    private CmafPackage(BuilderImpl builder) {
        this.encryption = builder.encryption;
        this.hlsManifests = builder.hlsManifests;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
    }

    public CmafEncryption encryption() {
        return this.encryption;
    }

    public List<HlsManifest> hlsManifests() {
        return this.hlsManifests;
    }

    public Integer segmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsManifests());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDurationSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafPackage)) {
            return false;
        }
        CmafPackage other = (CmafPackage)obj;
        return Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.hlsManifests(), other.hlsManifests()) && Objects.equals(this.segmentDurationSeconds(), other.segmentDurationSeconds());
    }

    public String toString() {
        return ToString.builder((String)"CmafPackage").add("Encryption", (Object)this.encryption()).add("HlsManifests", this.hlsManifests()).add("SegmentDurationSeconds", (Object)this.segmentDurationSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "HlsManifests": {
                return Optional.ofNullable(clazz.cast(this.hlsManifests()));
            }
            case "SegmentDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.segmentDurationSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CmafPackage, T> g) {
        return obj -> g.apply((CmafPackage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CmafEncryption encryption;
        private List<HlsManifest> hlsManifests = DefaultSdkAutoConstructList.getInstance();
        private Integer segmentDurationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(CmafPackage model) {
            this.encryption(model.encryption);
            this.hlsManifests(model.hlsManifests);
            this.segmentDurationSeconds(model.segmentDurationSeconds);
        }

        public final CmafEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(CmafEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(CmafEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Collection<HlsManifest.Builder> getHlsManifests() {
            return this.hlsManifests != null ? (Collection)this.hlsManifests.stream().map(HlsManifest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hlsManifests(Collection<HlsManifest> hlsManifests) {
            this.hlsManifests = ___listOfHlsManifestCopier.copy(hlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(HlsManifest ... hlsManifests) {
            this.hlsManifests(Arrays.asList(hlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(Consumer<HlsManifest.Builder> ... hlsManifests) {
            this.hlsManifests(Stream.of(hlsManifests).map(c -> (HlsManifest)((HlsManifest.Builder)HlsManifest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHlsManifests(Collection<HlsManifest.BuilderImpl> hlsManifests) {
            this.hlsManifests = ___listOfHlsManifestCopier.copyFromBuilder(hlsManifests);
        }

        public final Integer getSegmentDurationSeconds() {
            return this.segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public CmafPackage build() {
            return new CmafPackage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CmafPackage> {
        public Builder encryption(CmafEncryption var1);

        default public Builder encryption(Consumer<CmafEncryption.Builder> encryption) {
            return this.encryption((CmafEncryption)((CmafEncryption.Builder)CmafEncryption.builder().applyMutation(encryption)).build());
        }

        public Builder hlsManifests(Collection<HlsManifest> var1);

        public Builder hlsManifests(HlsManifest ... var1);

        public Builder hlsManifests(Consumer<HlsManifest.Builder> ... var1);

        public Builder segmentDurationSeconds(Integer var1);
    }
}

