/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePackagingGroupResponse extends MediaPackageVodResponse implements
        ToCopyableBuilder<UpdatePackagingGroupResponse.Builder, UpdatePackagingGroupResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdatePackagingGroupResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Authorization> AUTHORIZATION_FIELD = SdkField.<Authorization> builder(MarshallingType.SDK_POJO)
            .memberName("Authorization").getter(getter(UpdatePackagingGroupResponse::authorization))
            .setter(setter(Builder::authorization)).constructor(Authorization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorization").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(UpdatePackagingGroupResponse::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdatePackagingGroupResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(UpdatePackagingGroupResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            AUTHORIZATION_FIELD, DOMAIN_NAME_FIELD, ID_FIELD, TAGS_FIELD));

    private final String arn;

    private final Authorization authorization;

    private final String domainName;

    private final String id;

    private final Map<String, String> tags;

    private UpdatePackagingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.authorization = builder.authorization;
        this.domainName = builder.domainName;
        this.id = builder.id;
        this.tags = builder.tags;
    }

    /**
     * The ARN of the PackagingGroup.
     * 
     * @return The ARN of the PackagingGroup.
     */
    public final String arn() {
        return arn;
    }

    /**
     * Returns the value of the Authorization property for this object.
     * 
     * @return The value of the Authorization property for this object.
     */
    public final Authorization authorization() {
        return authorization;
    }

    /**
     * The fully qualified domain name for Assets in the PackagingGroup.
     * 
     * @return The fully qualified domain name for Assets in the PackagingGroup.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * The ID of the PackagingGroup.
     * 
     * @return The ID of the PackagingGroup.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(authorization());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackagingGroupResponse)) {
            return false;
        }
        UpdatePackagingGroupResponse other = (UpdatePackagingGroupResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(authorization(), other.authorization())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(id(), other.id())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePackagingGroupResponse").add("Arn", arn()).add("Authorization", authorization())
                .add("DomainName", domainName()).add("Id", id()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Authorization":
            return Optional.ofNullable(clazz.cast(authorization()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackagingGroupResponse, T> g) {
        return obj -> g.apply((UpdatePackagingGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageVodResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePackagingGroupResponse> {
        /**
         * The ARN of the PackagingGroup.
         * 
         * @param arn
         *        The ARN of the PackagingGroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Sets the value of the Authorization property for this object.
         *
         * @param authorization
         *        The new value for the Authorization property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorization(Authorization authorization);

        /**
         * Sets the value of the Authorization property for this object.
         *
         * This is a convenience that creates an instance of the {@link Authorization.Builder} avoiding the need to
         * create one manually via {@link Authorization#builder()}.
         *
         * When the {@link Consumer} completes, {@link Authorization.Builder#build()} is called immediately and its
         * result is passed to {@link #authorization(Authorization)}.
         * 
         * @param authorization
         *        a consumer that will call methods on {@link Authorization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorization(Authorization)
         */
        default Builder authorization(Consumer<Authorization.Builder> authorization) {
            return authorization(Authorization.builder().applyMutation(authorization).build());
        }

        /**
         * The fully qualified domain name for Assets in the PackagingGroup.
         * 
         * @param domainName
         *        The fully qualified domain name for Assets in the PackagingGroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * The ID of the PackagingGroup.
         * 
         * @param id
         *        The ID of the PackagingGroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends MediaPackageVodResponse.BuilderImpl implements Builder {
        private String arn;

        private Authorization authorization;

        private String domainName;

        private String id;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackagingGroupResponse model) {
            super(model);
            arn(model.arn);
            authorization(model.authorization);
            domainName(model.domainName);
            id(model.id);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Authorization.Builder getAuthorization() {
            return authorization != null ? authorization.toBuilder() : null;
        }

        @Override
        public final Builder authorization(Authorization authorization) {
            this.authorization = authorization;
            return this;
        }

        public final void setAuthorization(Authorization.BuilderImpl authorization) {
            this.authorization = authorization != null ? authorization.build() : null;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public UpdatePackagingGroupResponse build() {
            return new UpdatePackagingGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
