/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The segment configuration, including the segment name, duration, and other configuration values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Segment implements SdkPojo, Serializable, ToCopyableBuilder<Segment.Builder, Segment> {
    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentDurationSeconds").getter(getter(Segment::segmentDurationSeconds))
            .setter(setter(Builder::segmentDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentDurationSeconds").build())
            .build();

    private static final SdkField<String> SEGMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentName").getter(getter(Segment::segmentName)).setter(setter(Builder::segmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentName").build()).build();

    private static final SdkField<Boolean> TS_USE_AUDIO_RENDITION_GROUP_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("TsUseAudioRenditionGroup")
            .getter(getter(Segment::tsUseAudioRenditionGroup)).setter(setter(Builder::tsUseAudioRenditionGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TsUseAudioRenditionGroup").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_IFRAME_ONLY_STREAMS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("IncludeIframeOnlyStreams")
            .getter(getter(Segment::includeIframeOnlyStreams)).setter(setter(Builder::includeIframeOnlyStreams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeIframeOnlyStreams").build())
            .build();

    private static final SdkField<Boolean> TS_INCLUDE_DVB_SUBTITLES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TsIncludeDvbSubtitles").getter(getter(Segment::tsIncludeDvbSubtitles))
            .setter(setter(Builder::tsIncludeDvbSubtitles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TsIncludeDvbSubtitles").build())
            .build();

    private static final SdkField<Scte> SCTE_FIELD = SdkField.<Scte> builder(MarshallingType.SDK_POJO).memberName("Scte")
            .getter(getter(Segment::scte)).setter(setter(Builder::scte)).constructor(Scte::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scte").build()).build();

    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.<Encryption> builder(MarshallingType.SDK_POJO)
            .memberName("Encryption").getter(getter(Segment::encryption)).setter(setter(Builder::encryption))
            .constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SEGMENT_DURATION_SECONDS_FIELD, SEGMENT_NAME_FIELD, TS_USE_AUDIO_RENDITION_GROUP_FIELD,
            INCLUDE_IFRAME_ONLY_STREAMS_FIELD, TS_INCLUDE_DVB_SUBTITLES_FIELD, SCTE_FIELD, ENCRYPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer segmentDurationSeconds;

    private final String segmentName;

    private final Boolean tsUseAudioRenditionGroup;

    private final Boolean includeIframeOnlyStreams;

    private final Boolean tsIncludeDvbSubtitles;

    private final Scte scte;

    private final Encryption encryption;

    private Segment(BuilderImpl builder) {
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.segmentName = builder.segmentName;
        this.tsUseAudioRenditionGroup = builder.tsUseAudioRenditionGroup;
        this.includeIframeOnlyStreams = builder.includeIframeOnlyStreams;
        this.tsIncludeDvbSubtitles = builder.tsIncludeDvbSubtitles;
        this.scte = builder.scte;
        this.encryption = builder.encryption;
    }

    /**
     * <p>
     * The duration (in seconds) of each segment. Enter a value equal to, or a multiple of, the input segment duration.
     * If the value that you enter is different from the input segment duration, MediaPackage rounds segments to the
     * nearest multiple of the input segment duration.
     * </p>
     * 
     * @return The duration (in seconds) of each segment. Enter a value equal to, or a multiple of, the input segment
     *         duration. If the value that you enter is different from the input segment duration, MediaPackage rounds
     *         segments to the nearest multiple of the input segment duration.
     */
    public final Integer segmentDurationSeconds() {
        return segmentDurationSeconds;
    }

    /**
     * <p>
     * The name that describes the segment. The name is the base name of the segment used in all content manifests
     * inside of the endpoint. You can't use spaces in the name.
     * </p>
     * 
     * @return The name that describes the segment. The name is the base name of the segment used in all content
     *         manifests inside of the endpoint. You can't use spaces in the name.
     */
    public final String segmentName() {
        return segmentName;
    }

    /**
     * <p>
     * When selected, MediaPackage bundles all audio tracks in a rendition group. All other tracks in the stream can be
     * used with any audio rendition from the group.
     * </p>
     * 
     * @return When selected, MediaPackage bundles all audio tracks in a rendition group. All other tracks in the stream
     *         can be used with any audio rendition from the group.
     */
    public final Boolean tsUseAudioRenditionGroup() {
        return tsUseAudioRenditionGroup;
    }

    /**
     * <p>
     * When selected, the stream set includes an additional I-frame only stream, along with the other tracks. If false,
     * this extra stream is not included. MediaPackage generates an I-frame only stream from the first rendition in the
     * manifest. The service inserts EXT-I-FRAMES-ONLY tags in the output manifest, and then generates and includes an
     * I-frames only playlist in the stream. This playlist permits player functionality like fast forward and rewind.
     * </p>
     * 
     * @return When selected, the stream set includes an additional I-frame only stream, along with the other tracks. If
     *         false, this extra stream is not included. MediaPackage generates an I-frame only stream from the first
     *         rendition in the manifest. The service inserts EXT-I-FRAMES-ONLY tags in the output manifest, and then
     *         generates and includes an I-frames only playlist in the stream. This playlist permits player
     *         functionality like fast forward and rewind.
     */
    public final Boolean includeIframeOnlyStreams() {
        return includeIframeOnlyStreams;
    }

    /**
     * <p>
     * By default, MediaPackage excludes all digital video broadcasting (DVB) subtitles from the output. When selected,
     * MediaPackage passes through DVB subtitles into the output.
     * </p>
     * 
     * @return By default, MediaPackage excludes all digital video broadcasting (DVB) subtitles from the output. When
     *         selected, MediaPackage passes through DVB subtitles into the output.
     */
    public final Boolean tsIncludeDvbSubtitles() {
        return tsIncludeDvbSubtitles;
    }

    /**
     * <p>
     * The SCTE configuration options in the segment settings.
     * </p>
     * 
     * @return The SCTE configuration options in the segment settings.
     */
    public final Scte scte() {
        return scte;
    }

    /**
     * Returns the value of the Encryption property for this object.
     * 
     * @return The value of the Encryption property for this object.
     */
    public final Encryption encryption() {
        return encryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(segmentName());
        hashCode = 31 * hashCode + Objects.hashCode(tsUseAudioRenditionGroup());
        hashCode = 31 * hashCode + Objects.hashCode(includeIframeOnlyStreams());
        hashCode = 31 * hashCode + Objects.hashCode(tsIncludeDvbSubtitles());
        hashCode = 31 * hashCode + Objects.hashCode(scte());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Segment)) {
            return false;
        }
        Segment other = (Segment) obj;
        return Objects.equals(segmentDurationSeconds(), other.segmentDurationSeconds())
                && Objects.equals(segmentName(), other.segmentName())
                && Objects.equals(tsUseAudioRenditionGroup(), other.tsUseAudioRenditionGroup())
                && Objects.equals(includeIframeOnlyStreams(), other.includeIframeOnlyStreams())
                && Objects.equals(tsIncludeDvbSubtitles(), other.tsIncludeDvbSubtitles()) && Objects.equals(scte(), other.scte())
                && Objects.equals(encryption(), other.encryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Segment").add("SegmentDurationSeconds", segmentDurationSeconds())
                .add("SegmentName", segmentName()).add("TsUseAudioRenditionGroup", tsUseAudioRenditionGroup())
                .add("IncludeIframeOnlyStreams", includeIframeOnlyStreams())
                .add("TsIncludeDvbSubtitles", tsIncludeDvbSubtitles()).add("Scte", scte()).add("Encryption", encryption())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SegmentDurationSeconds":
            return Optional.ofNullable(clazz.cast(segmentDurationSeconds()));
        case "SegmentName":
            return Optional.ofNullable(clazz.cast(segmentName()));
        case "TsUseAudioRenditionGroup":
            return Optional.ofNullable(clazz.cast(tsUseAudioRenditionGroup()));
        case "IncludeIframeOnlyStreams":
            return Optional.ofNullable(clazz.cast(includeIframeOnlyStreams()));
        case "TsIncludeDvbSubtitles":
            return Optional.ofNullable(clazz.cast(tsIncludeDvbSubtitles()));
        case "Scte":
            return Optional.ofNullable(clazz.cast(scte()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SegmentDurationSeconds", SEGMENT_DURATION_SECONDS_FIELD);
        map.put("SegmentName", SEGMENT_NAME_FIELD);
        map.put("TsUseAudioRenditionGroup", TS_USE_AUDIO_RENDITION_GROUP_FIELD);
        map.put("IncludeIframeOnlyStreams", INCLUDE_IFRAME_ONLY_STREAMS_FIELD);
        map.put("TsIncludeDvbSubtitles", TS_INCLUDE_DVB_SUBTITLES_FIELD);
        map.put("Scte", SCTE_FIELD);
        map.put("Encryption", ENCRYPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Segment, T> g) {
        return obj -> g.apply((Segment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Segment> {
        /**
         * <p>
         * The duration (in seconds) of each segment. Enter a value equal to, or a multiple of, the input segment
         * duration. If the value that you enter is different from the input segment duration, MediaPackage rounds
         * segments to the nearest multiple of the input segment duration.
         * </p>
         * 
         * @param segmentDurationSeconds
         *        The duration (in seconds) of each segment. Enter a value equal to, or a multiple of, the input segment
         *        duration. If the value that you enter is different from the input segment duration, MediaPackage
         *        rounds segments to the nearest multiple of the input segment duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDurationSeconds(Integer segmentDurationSeconds);

        /**
         * <p>
         * The name that describes the segment. The name is the base name of the segment used in all content manifests
         * inside of the endpoint. You can't use spaces in the name.
         * </p>
         * 
         * @param segmentName
         *        The name that describes the segment. The name is the base name of the segment used in all content
         *        manifests inside of the endpoint. You can't use spaces in the name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentName(String segmentName);

        /**
         * <p>
         * When selected, MediaPackage bundles all audio tracks in a rendition group. All other tracks in the stream can
         * be used with any audio rendition from the group.
         * </p>
         * 
         * @param tsUseAudioRenditionGroup
         *        When selected, MediaPackage bundles all audio tracks in a rendition group. All other tracks in the
         *        stream can be used with any audio rendition from the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tsUseAudioRenditionGroup(Boolean tsUseAudioRenditionGroup);

        /**
         * <p>
         * When selected, the stream set includes an additional I-frame only stream, along with the other tracks. If
         * false, this extra stream is not included. MediaPackage generates an I-frame only stream from the first
         * rendition in the manifest. The service inserts EXT-I-FRAMES-ONLY tags in the output manifest, and then
         * generates and includes an I-frames only playlist in the stream. This playlist permits player functionality
         * like fast forward and rewind.
         * </p>
         * 
         * @param includeIframeOnlyStreams
         *        When selected, the stream set includes an additional I-frame only stream, along with the other tracks.
         *        If false, this extra stream is not included. MediaPackage generates an I-frame only stream from the
         *        first rendition in the manifest. The service inserts EXT-I-FRAMES-ONLY tags in the output manifest,
         *        and then generates and includes an I-frames only playlist in the stream. This playlist permits player
         *        functionality like fast forward and rewind.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeIframeOnlyStreams(Boolean includeIframeOnlyStreams);

        /**
         * <p>
         * By default, MediaPackage excludes all digital video broadcasting (DVB) subtitles from the output. When
         * selected, MediaPackage passes through DVB subtitles into the output.
         * </p>
         * 
         * @param tsIncludeDvbSubtitles
         *        By default, MediaPackage excludes all digital video broadcasting (DVB) subtitles from the output. When
         *        selected, MediaPackage passes through DVB subtitles into the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tsIncludeDvbSubtitles(Boolean tsIncludeDvbSubtitles);

        /**
         * <p>
         * The SCTE configuration options in the segment settings.
         * </p>
         * 
         * @param scte
         *        The SCTE configuration options in the segment settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte(Scte scte);

        /**
         * <p>
         * The SCTE configuration options in the segment settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link Scte.Builder} avoiding the need to create
         * one manually via {@link Scte#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Scte.Builder#build()} is called immediately and its result is
         * passed to {@link #scte(Scte)}.
         * 
         * @param scte
         *        a consumer that will call methods on {@link Scte.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scte(Scte)
         */
        default Builder scte(Consumer<Scte.Builder> scte) {
            return scte(Scte.builder().applyMutation(scte).build());
        }

        /**
         * Sets the value of the Encryption property for this object.
         *
         * @param encryption
         *        The new value for the Encryption property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(Encryption encryption);

        /**
         * Sets the value of the Encryption property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Encryption.Builder} avoiding the need to
         * create one manually via {@link Encryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #encryption(Encryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(Encryption)
         */
        default Builder encryption(Consumer<Encryption.Builder> encryption) {
            return encryption(Encryption.builder().applyMutation(encryption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer segmentDurationSeconds;

        private String segmentName;

        private Boolean tsUseAudioRenditionGroup;

        private Boolean includeIframeOnlyStreams;

        private Boolean tsIncludeDvbSubtitles;

        private Scte scte;

        private Encryption encryption;

        private BuilderImpl() {
        }

        private BuilderImpl(Segment model) {
            segmentDurationSeconds(model.segmentDurationSeconds);
            segmentName(model.segmentName);
            tsUseAudioRenditionGroup(model.tsUseAudioRenditionGroup);
            includeIframeOnlyStreams(model.includeIframeOnlyStreams);
            tsIncludeDvbSubtitles(model.tsIncludeDvbSubtitles);
            scte(model.scte);
            encryption(model.encryption);
        }

        public final Integer getSegmentDurationSeconds() {
            return segmentDurationSeconds;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final String getSegmentName() {
            return segmentName;
        }

        public final void setSegmentName(String segmentName) {
            this.segmentName = segmentName;
        }

        @Override
        public final Builder segmentName(String segmentName) {
            this.segmentName = segmentName;
            return this;
        }

        public final Boolean getTsUseAudioRenditionGroup() {
            return tsUseAudioRenditionGroup;
        }

        public final void setTsUseAudioRenditionGroup(Boolean tsUseAudioRenditionGroup) {
            this.tsUseAudioRenditionGroup = tsUseAudioRenditionGroup;
        }

        @Override
        public final Builder tsUseAudioRenditionGroup(Boolean tsUseAudioRenditionGroup) {
            this.tsUseAudioRenditionGroup = tsUseAudioRenditionGroup;
            return this;
        }

        public final Boolean getIncludeIframeOnlyStreams() {
            return includeIframeOnlyStreams;
        }

        public final void setIncludeIframeOnlyStreams(Boolean includeIframeOnlyStreams) {
            this.includeIframeOnlyStreams = includeIframeOnlyStreams;
        }

        @Override
        public final Builder includeIframeOnlyStreams(Boolean includeIframeOnlyStreams) {
            this.includeIframeOnlyStreams = includeIframeOnlyStreams;
            return this;
        }

        public final Boolean getTsIncludeDvbSubtitles() {
            return tsIncludeDvbSubtitles;
        }

        public final void setTsIncludeDvbSubtitles(Boolean tsIncludeDvbSubtitles) {
            this.tsIncludeDvbSubtitles = tsIncludeDvbSubtitles;
        }

        @Override
        public final Builder tsIncludeDvbSubtitles(Boolean tsIncludeDvbSubtitles) {
            this.tsIncludeDvbSubtitles = tsIncludeDvbSubtitles;
            return this;
        }

        public final Scte.Builder getScte() {
            return scte != null ? scte.toBuilder() : null;
        }

        public final void setScte(Scte.BuilderImpl scte) {
            this.scte = scte != null ? scte.build() : null;
        }

        @Override
        public final Builder scte(Scte scte) {
            this.scte = scte;
            return this;
        }

        public final Encryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        @Override
        public Segment build() {
            return new Segment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
