/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the origin endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OriginEndpointListConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OriginEndpointListConfiguration.Builder, OriginEndpointListConfiguration> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(OriginEndpointListConfiguration::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelGroupName").getter(getter(OriginEndpointListConfiguration::channelGroupName))
            .setter(setter(Builder::channelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelGroupName").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(OriginEndpointListConfiguration::channelName))
            .setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<String> ORIGIN_ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginEndpointName").getter(getter(OriginEndpointListConfiguration::originEndpointName))
            .setter(setter(Builder::originEndpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginEndpointName").build())
            .build();

    private static final SdkField<String> CONTAINER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerType").getter(getter(OriginEndpointListConfiguration::containerTypeAsString))
            .setter(setter(Builder::containerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(OriginEndpointListConfiguration::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(OriginEndpointListConfiguration::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedAt").getter(getter(OriginEndpointListConfiguration::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build()).build();

    private static final SdkField<List<ListHlsManifestConfiguration>> HLS_MANIFESTS_FIELD = SdkField
            .<List<ListHlsManifestConfiguration>> builder(MarshallingType.LIST)
            .memberName("HlsManifests")
            .getter(getter(OriginEndpointListConfiguration::hlsManifests))
            .setter(setter(Builder::hlsManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListHlsManifestConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListHlsManifestConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ListLowLatencyHlsManifestConfiguration>> LOW_LATENCY_HLS_MANIFESTS_FIELD = SdkField
            .<List<ListLowLatencyHlsManifestConfiguration>> builder(MarshallingType.LIST)
            .memberName("LowLatencyHlsManifests")
            .getter(getter(OriginEndpointListConfiguration::lowLatencyHlsManifests))
            .setter(setter(Builder::lowLatencyHlsManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowLatencyHlsManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListLowLatencyHlsManifestConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListLowLatencyHlsManifestConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ListDashManifestConfiguration>> DASH_MANIFESTS_FIELD = SdkField
            .<List<ListDashManifestConfiguration>> builder(MarshallingType.LIST)
            .memberName("DashManifests")
            .getter(getter(OriginEndpointListConfiguration::dashManifests))
            .setter(setter(Builder::dashManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListDashManifestConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListDashManifestConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ListMssManifestConfiguration>> MSS_MANIFESTS_FIELD = SdkField
            .<List<ListMssManifestConfiguration>> builder(MarshallingType.LIST)
            .memberName("MssManifests")
            .getter(getter(OriginEndpointListConfiguration::mssManifests))
            .setter(setter(Builder::mssManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MssManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListMssManifestConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListMssManifestConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ForceEndpointErrorConfiguration> FORCE_ENDPOINT_ERROR_CONFIGURATION_FIELD = SdkField
            .<ForceEndpointErrorConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ForceEndpointErrorConfiguration")
            .getter(getter(OriginEndpointListConfiguration::forceEndpointErrorConfiguration))
            .setter(setter(Builder::forceEndpointErrorConfiguration))
            .constructor(ForceEndpointErrorConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceEndpointErrorConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CHANNEL_GROUP_NAME_FIELD, CHANNEL_NAME_FIELD, ORIGIN_ENDPOINT_NAME_FIELD, CONTAINER_TYPE_FIELD, DESCRIPTION_FIELD,
            CREATED_AT_FIELD, MODIFIED_AT_FIELD, HLS_MANIFESTS_FIELD, LOW_LATENCY_HLS_MANIFESTS_FIELD, DASH_MANIFESTS_FIELD,
            MSS_MANIFESTS_FIELD, FORCE_ENDPOINT_ERROR_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String channelGroupName;

    private final String channelName;

    private final String originEndpointName;

    private final String containerType;

    private final String description;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final List<ListHlsManifestConfiguration> hlsManifests;

    private final List<ListLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests;

    private final List<ListDashManifestConfiguration> dashManifests;

    private final List<ListMssManifestConfiguration> mssManifests;

    private final ForceEndpointErrorConfiguration forceEndpointErrorConfiguration;

    private OriginEndpointListConfiguration(BuilderImpl builder) {
        this.arn = builder.arn;
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.originEndpointName = builder.originEndpointName;
        this.containerType = builder.containerType;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.hlsManifests = builder.hlsManifests;
        this.lowLatencyHlsManifests = builder.lowLatencyHlsManifests;
        this.dashManifests = builder.dashManifests;
        this.mssManifests = builder.mssManifests;
        this.forceEndpointErrorConfiguration = builder.forceEndpointErrorConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name that describes the channel group. The name is the primary identifier for the channel group, and must be
     * unique for your account in the AWS Region.
     * </p>
     * 
     * @return The name that describes the channel group. The name is the primary identifier for the channel group, and
     *         must be unique for your account in the AWS Region.
     */
    public final String channelGroupName() {
        return channelGroupName;
    }

    /**
     * <p>
     * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for
     * your account in the AWS Region and channel group.
     * </p>
     * 
     * @return The name that describes the channel. The name is the primary identifier for the channel, and must be
     *         unique for your account in the AWS Region and channel group.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and
     * must be unique for your account in the AWS Region and channel.
     * </p>
     * 
     * @return The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint,
     *         and and must be unique for your account in the AWS Region and channel.
     */
    public final String originEndpointName() {
        return originEndpointName;
    }

    /**
     * <p>
     * The type of container attached to this origin endpoint. A container type is a file format that encapsulates one
     * or more media streams, such as audio and video, into a single file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerType}
     * will return {@link ContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #containerTypeAsString}.
     * </p>
     * 
     * @return The type of container attached to this origin endpoint. A container type is a file format that
     *         encapsulates one or more media streams, such as audio and video, into a single file.
     * @see ContainerType
     */
    public final ContainerType containerType() {
        return ContainerType.fromValue(containerType);
    }

    /**
     * <p>
     * The type of container attached to this origin endpoint. A container type is a file format that encapsulates one
     * or more media streams, such as audio and video, into a single file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerType}
     * will return {@link ContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #containerTypeAsString}.
     * </p>
     * 
     * @return The type of container attached to this origin endpoint. A container type is a file format that
     *         encapsulates one or more media streams, such as audio and video, into a single file.
     * @see ContainerType
     */
    public final String containerTypeAsString() {
        return containerType;
    }

    /**
     * <p>
     * Any descriptive information that you want to add to the origin endpoint for future identification purposes.
     * </p>
     * 
     * @return Any descriptive information that you want to add to the origin endpoint for future identification
     *         purposes.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date and time the origin endpoint was created.
     * </p>
     * 
     * @return The date and time the origin endpoint was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time the origin endpoint was modified.
     * </p>
     * 
     * @return The date and time the origin endpoint was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the HlsManifests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHlsManifests() {
        return hlsManifests != null && !(hlsManifests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An HTTP live streaming (HLS) manifest configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHlsManifests} method.
     * </p>
     * 
     * @return An HTTP live streaming (HLS) manifest configuration.
     */
    public final List<ListHlsManifestConfiguration> hlsManifests() {
        return hlsManifests;
    }

    /**
     * For responses, this returns true if the service returned a value for the LowLatencyHlsManifests property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLowLatencyHlsManifests() {
        return lowLatencyHlsManifests != null && !(lowLatencyHlsManifests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A low-latency HLS manifest configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLowLatencyHlsManifests} method.
     * </p>
     * 
     * @return A low-latency HLS manifest configuration.
     */
    public final List<ListLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests() {
        return lowLatencyHlsManifests;
    }

    /**
     * For responses, this returns true if the service returned a value for the DashManifests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDashManifests() {
        return dashManifests != null && !(dashManifests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A DASH manifest configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDashManifests} method.
     * </p>
     * 
     * @return A DASH manifest configuration.
     */
    public final List<ListDashManifestConfiguration> dashManifests() {
        return dashManifests;
    }

    /**
     * For responses, this returns true if the service returned a value for the MssManifests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMssManifests() {
        return mssManifests != null && !(mssManifests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Microsoft Smooth Streaming (MSS) manifest configurations associated with the origin endpoint. Each
     * configuration represents a different MSS streaming option available from this endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMssManifests} method.
     * </p>
     * 
     * @return A list of Microsoft Smooth Streaming (MSS) manifest configurations associated with the origin endpoint.
     *         Each configuration represents a different MSS streaming option available from this endpoint.
     */
    public final List<ListMssManifestConfiguration> mssManifests() {
        return mssManifests;
    }

    /**
     * <p>
     * The failover settings for the endpoint.
     * </p>
     * 
     * @return The failover settings for the endpoint.
     */
    public final ForceEndpointErrorConfiguration forceEndpointErrorConfiguration() {
        return forceEndpointErrorConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(originEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(containerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasHlsManifests() ? hlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLowLatencyHlsManifests() ? lowLatencyHlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDashManifests() ? dashManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMssManifests() ? mssManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(forceEndpointErrorConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginEndpointListConfiguration)) {
            return false;
        }
        OriginEndpointListConfiguration other = (OriginEndpointListConfiguration) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(channelGroupName(), other.channelGroupName())
                && Objects.equals(channelName(), other.channelName())
                && Objects.equals(originEndpointName(), other.originEndpointName())
                && Objects.equals(containerTypeAsString(), other.containerTypeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt()) && hasHlsManifests() == other.hasHlsManifests()
                && Objects.equals(hlsManifests(), other.hlsManifests())
                && hasLowLatencyHlsManifests() == other.hasLowLatencyHlsManifests()
                && Objects.equals(lowLatencyHlsManifests(), other.lowLatencyHlsManifests())
                && hasDashManifests() == other.hasDashManifests() && Objects.equals(dashManifests(), other.dashManifests())
                && hasMssManifests() == other.hasMssManifests() && Objects.equals(mssManifests(), other.mssManifests())
                && Objects.equals(forceEndpointErrorConfiguration(), other.forceEndpointErrorConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OriginEndpointListConfiguration").add("Arn", arn()).add("ChannelGroupName", channelGroupName())
                .add("ChannelName", channelName()).add("OriginEndpointName", originEndpointName())
                .add("ContainerType", containerTypeAsString()).add("Description", description()).add("CreatedAt", createdAt())
                .add("ModifiedAt", modifiedAt()).add("HlsManifests", hasHlsManifests() ? hlsManifests() : null)
                .add("LowLatencyHlsManifests", hasLowLatencyHlsManifests() ? lowLatencyHlsManifests() : null)
                .add("DashManifests", hasDashManifests() ? dashManifests() : null)
                .add("MssManifests", hasMssManifests() ? mssManifests() : null)
                .add("ForceEndpointErrorConfiguration", forceEndpointErrorConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ChannelGroupName":
            return Optional.ofNullable(clazz.cast(channelGroupName()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "OriginEndpointName":
            return Optional.ofNullable(clazz.cast(originEndpointName()));
        case "ContainerType":
            return Optional.ofNullable(clazz.cast(containerTypeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ModifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "HlsManifests":
            return Optional.ofNullable(clazz.cast(hlsManifests()));
        case "LowLatencyHlsManifests":
            return Optional.ofNullable(clazz.cast(lowLatencyHlsManifests()));
        case "DashManifests":
            return Optional.ofNullable(clazz.cast(dashManifests()));
        case "MssManifests":
            return Optional.ofNullable(clazz.cast(mssManifests()));
        case "ForceEndpointErrorConfiguration":
            return Optional.ofNullable(clazz.cast(forceEndpointErrorConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("ChannelGroupName", CHANNEL_GROUP_NAME_FIELD);
        map.put("ChannelName", CHANNEL_NAME_FIELD);
        map.put("OriginEndpointName", ORIGIN_ENDPOINT_NAME_FIELD);
        map.put("ContainerType", CONTAINER_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("ModifiedAt", MODIFIED_AT_FIELD);
        map.put("HlsManifests", HLS_MANIFESTS_FIELD);
        map.put("LowLatencyHlsManifests", LOW_LATENCY_HLS_MANIFESTS_FIELD);
        map.put("DashManifests", DASH_MANIFESTS_FIELD);
        map.put("MssManifests", MSS_MANIFESTS_FIELD);
        map.put("ForceEndpointErrorConfiguration", FORCE_ENDPOINT_ERROR_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OriginEndpointListConfiguration, T> g) {
        return obj -> g.apply((OriginEndpointListConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OriginEndpointListConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) associated with the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name that describes the channel group. The name is the primary identifier for the channel group, and must
         * be unique for your account in the AWS Region.
         * </p>
         * 
         * @param channelGroupName
         *        The name that describes the channel group. The name is the primary identifier for the channel group,
         *        and must be unique for your account in the AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelGroupName(String channelGroupName);

        /**
         * <p>
         * The name that describes the channel. The name is the primary identifier for the channel, and must be unique
         * for your account in the AWS Region and channel group.
         * </p>
         * 
         * @param channelName
         *        The name that describes the channel. The name is the primary identifier for the channel, and must be
         *        unique for your account in the AWS Region and channel group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and
         * and must be unique for your account in the AWS Region and channel.
         * </p>
         * 
         * @param originEndpointName
         *        The name that describes the origin endpoint. The name is the primary identifier for the origin
         *        endpoint, and and must be unique for your account in the AWS Region and channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originEndpointName(String originEndpointName);

        /**
         * <p>
         * The type of container attached to this origin endpoint. A container type is a file format that encapsulates
         * one or more media streams, such as audio and video, into a single file.
         * </p>
         * 
         * @param containerType
         *        The type of container attached to this origin endpoint. A container type is a file format that
         *        encapsulates one or more media streams, such as audio and video, into a single file.
         * @see ContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerType
         */
        Builder containerType(String containerType);

        /**
         * <p>
         * The type of container attached to this origin endpoint. A container type is a file format that encapsulates
         * one or more media streams, such as audio and video, into a single file.
         * </p>
         * 
         * @param containerType
         *        The type of container attached to this origin endpoint. A container type is a file format that
         *        encapsulates one or more media streams, such as audio and video, into a single file.
         * @see ContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerType
         */
        Builder containerType(ContainerType containerType);

        /**
         * <p>
         * Any descriptive information that you want to add to the origin endpoint for future identification purposes.
         * </p>
         * 
         * @param description
         *        Any descriptive information that you want to add to the origin endpoint for future identification
         *        purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time the origin endpoint was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the origin endpoint was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time the origin endpoint was modified.
         * </p>
         * 
         * @param modifiedAt
         *        The date and time the origin endpoint was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * An HTTP live streaming (HLS) manifest configuration.
         * </p>
         * 
         * @param hlsManifests
         *        An HTTP live streaming (HLS) manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsManifests(Collection<ListHlsManifestConfiguration> hlsManifests);

        /**
         * <p>
         * An HTTP live streaming (HLS) manifest configuration.
         * </p>
         * 
         * @param hlsManifests
         *        An HTTP live streaming (HLS) manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsManifests(ListHlsManifestConfiguration... hlsManifests);

        /**
         * <p>
         * An HTTP live streaming (HLS) manifest configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagev2.model.ListHlsManifestConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.mediapackagev2.model.ListHlsManifestConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagev2.model.ListHlsManifestConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #hlsManifests(List<ListHlsManifestConfiguration>)}.
         * 
         * @param hlsManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListHlsManifestConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsManifests(java.util.Collection<ListHlsManifestConfiguration>)
         */
        Builder hlsManifests(Consumer<ListHlsManifestConfiguration.Builder>... hlsManifests);

        /**
         * <p>
         * A low-latency HLS manifest configuration.
         * </p>
         * 
         * @param lowLatencyHlsManifests
         *        A low-latency HLS manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowLatencyHlsManifests(Collection<ListLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests);

        /**
         * <p>
         * A low-latency HLS manifest configuration.
         * </p>
         * 
         * @param lowLatencyHlsManifests
         *        A low-latency HLS manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowLatencyHlsManifests(ListLowLatencyHlsManifestConfiguration... lowLatencyHlsManifests);

        /**
         * <p>
         * A low-latency HLS manifest configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagev2.model.ListLowLatencyHlsManifestConfiguration.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.mediapackagev2.model.ListLowLatencyHlsManifestConfiguration#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagev2.model.ListLowLatencyHlsManifestConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #lowLatencyHlsManifests(List<ListLowLatencyHlsManifestConfiguration>)}.
         * 
         * @param lowLatencyHlsManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListLowLatencyHlsManifestConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lowLatencyHlsManifests(java.util.Collection<ListLowLatencyHlsManifestConfiguration>)
         */
        Builder lowLatencyHlsManifests(Consumer<ListLowLatencyHlsManifestConfiguration.Builder>... lowLatencyHlsManifests);

        /**
         * <p>
         * A DASH manifest configuration.
         * </p>
         * 
         * @param dashManifests
         *        A DASH manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashManifests(Collection<ListDashManifestConfiguration> dashManifests);

        /**
         * <p>
         * A DASH manifest configuration.
         * </p>
         * 
         * @param dashManifests
         *        A DASH manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashManifests(ListDashManifestConfiguration... dashManifests);

        /**
         * <p>
         * A DASH manifest configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagev2.model.ListDashManifestConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.mediapackagev2.model.ListDashManifestConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagev2.model.ListDashManifestConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #dashManifests(List<ListDashManifestConfiguration>)}.
         * 
         * @param dashManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListDashManifestConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashManifests(java.util.Collection<ListDashManifestConfiguration>)
         */
        Builder dashManifests(Consumer<ListDashManifestConfiguration.Builder>... dashManifests);

        /**
         * <p>
         * A list of Microsoft Smooth Streaming (MSS) manifest configurations associated with the origin endpoint. Each
         * configuration represents a different MSS streaming option available from this endpoint.
         * </p>
         * 
         * @param mssManifests
         *        A list of Microsoft Smooth Streaming (MSS) manifest configurations associated with the origin
         *        endpoint. Each configuration represents a different MSS streaming option available from this endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mssManifests(Collection<ListMssManifestConfiguration> mssManifests);

        /**
         * <p>
         * A list of Microsoft Smooth Streaming (MSS) manifest configurations associated with the origin endpoint. Each
         * configuration represents a different MSS streaming option available from this endpoint.
         * </p>
         * 
         * @param mssManifests
         *        A list of Microsoft Smooth Streaming (MSS) manifest configurations associated with the origin
         *        endpoint. Each configuration represents a different MSS streaming option available from this endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mssManifests(ListMssManifestConfiguration... mssManifests);

        /**
         * <p>
         * A list of Microsoft Smooth Streaming (MSS) manifest configurations associated with the origin endpoint. Each
         * configuration represents a different MSS streaming option available from this endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagev2.model.ListMssManifestConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.mediapackagev2.model.ListMssManifestConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagev2.model.ListMssManifestConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #mssManifests(List<ListMssManifestConfiguration>)}.
         * 
         * @param mssManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListMssManifestConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mssManifests(java.util.Collection<ListMssManifestConfiguration>)
         */
        Builder mssManifests(Consumer<ListMssManifestConfiguration.Builder>... mssManifests);

        /**
         * <p>
         * The failover settings for the endpoint.
         * </p>
         * 
         * @param forceEndpointErrorConfiguration
         *        The failover settings for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceEndpointErrorConfiguration(ForceEndpointErrorConfiguration forceEndpointErrorConfiguration);

        /**
         * <p>
         * The failover settings for the endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link ForceEndpointErrorConfiguration.Builder}
         * avoiding the need to create one manually via {@link ForceEndpointErrorConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ForceEndpointErrorConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #forceEndpointErrorConfiguration(ForceEndpointErrorConfiguration)}.
         * 
         * @param forceEndpointErrorConfiguration
         *        a consumer that will call methods on {@link ForceEndpointErrorConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forceEndpointErrorConfiguration(ForceEndpointErrorConfiguration)
         */
        default Builder forceEndpointErrorConfiguration(
                Consumer<ForceEndpointErrorConfiguration.Builder> forceEndpointErrorConfiguration) {
            return forceEndpointErrorConfiguration(ForceEndpointErrorConfiguration.builder()
                    .applyMutation(forceEndpointErrorConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String channelGroupName;

        private String channelName;

        private String originEndpointName;

        private String containerType;

        private String description;

        private Instant createdAt;

        private Instant modifiedAt;

        private List<ListHlsManifestConfiguration> hlsManifests = DefaultSdkAutoConstructList.getInstance();

        private List<ListLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests = DefaultSdkAutoConstructList.getInstance();

        private List<ListDashManifestConfiguration> dashManifests = DefaultSdkAutoConstructList.getInstance();

        private List<ListMssManifestConfiguration> mssManifests = DefaultSdkAutoConstructList.getInstance();

        private ForceEndpointErrorConfiguration forceEndpointErrorConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginEndpointListConfiguration model) {
            arn(model.arn);
            channelGroupName(model.channelGroupName);
            channelName(model.channelName);
            originEndpointName(model.originEndpointName);
            containerType(model.containerType);
            description(model.description);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            hlsManifests(model.hlsManifests);
            lowLatencyHlsManifests(model.lowLatencyHlsManifests);
            dashManifests(model.dashManifests);
            mssManifests(model.mssManifests);
            forceEndpointErrorConfiguration(model.forceEndpointErrorConfiguration);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getChannelGroupName() {
            return channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getOriginEndpointName() {
            return originEndpointName;
        }

        public final void setOriginEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
        }

        @Override
        public final Builder originEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
            return this;
        }

        public final String getContainerType() {
            return containerType;
        }

        public final void setContainerType(String containerType) {
            this.containerType = containerType;
        }

        @Override
        public final Builder containerType(String containerType) {
            this.containerType = containerType;
            return this;
        }

        @Override
        public final Builder containerType(ContainerType containerType) {
            this.containerType(containerType == null ? null : containerType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final List<ListHlsManifestConfiguration.Builder> getHlsManifests() {
            List<ListHlsManifestConfiguration.Builder> result = ListHlsManifestsCopier.copyToBuilder(this.hlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHlsManifests(Collection<ListHlsManifestConfiguration.BuilderImpl> hlsManifests) {
            this.hlsManifests = ListHlsManifestsCopier.copyFromBuilder(hlsManifests);
        }

        @Override
        public final Builder hlsManifests(Collection<ListHlsManifestConfiguration> hlsManifests) {
            this.hlsManifests = ListHlsManifestsCopier.copy(hlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(ListHlsManifestConfiguration... hlsManifests) {
            hlsManifests(Arrays.asList(hlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(Consumer<ListHlsManifestConfiguration.Builder>... hlsManifests) {
            hlsManifests(Stream.of(hlsManifests).map(c -> ListHlsManifestConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ListLowLatencyHlsManifestConfiguration.Builder> getLowLatencyHlsManifests() {
            List<ListLowLatencyHlsManifestConfiguration.Builder> result = ListLowLatencyHlsManifestsCopier
                    .copyToBuilder(this.lowLatencyHlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLowLatencyHlsManifests(
                Collection<ListLowLatencyHlsManifestConfiguration.BuilderImpl> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = ListLowLatencyHlsManifestsCopier.copyFromBuilder(lowLatencyHlsManifests);
        }

        @Override
        public final Builder lowLatencyHlsManifests(Collection<ListLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = ListLowLatencyHlsManifestsCopier.copy(lowLatencyHlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(ListLowLatencyHlsManifestConfiguration... lowLatencyHlsManifests) {
            lowLatencyHlsManifests(Arrays.asList(lowLatencyHlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(
                Consumer<ListLowLatencyHlsManifestConfiguration.Builder>... lowLatencyHlsManifests) {
            lowLatencyHlsManifests(Stream.of(lowLatencyHlsManifests)
                    .map(c -> ListLowLatencyHlsManifestConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ListDashManifestConfiguration.Builder> getDashManifests() {
            List<ListDashManifestConfiguration.Builder> result = ListDashManifestsCopier.copyToBuilder(this.dashManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDashManifests(Collection<ListDashManifestConfiguration.BuilderImpl> dashManifests) {
            this.dashManifests = ListDashManifestsCopier.copyFromBuilder(dashManifests);
        }

        @Override
        public final Builder dashManifests(Collection<ListDashManifestConfiguration> dashManifests) {
            this.dashManifests = ListDashManifestsCopier.copy(dashManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(ListDashManifestConfiguration... dashManifests) {
            dashManifests(Arrays.asList(dashManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(Consumer<ListDashManifestConfiguration.Builder>... dashManifests) {
            dashManifests(Stream.of(dashManifests).map(c -> ListDashManifestConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ListMssManifestConfiguration.Builder> getMssManifests() {
            List<ListMssManifestConfiguration.Builder> result = ListMssManifestsCopier.copyToBuilder(this.mssManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMssManifests(Collection<ListMssManifestConfiguration.BuilderImpl> mssManifests) {
            this.mssManifests = ListMssManifestsCopier.copyFromBuilder(mssManifests);
        }

        @Override
        public final Builder mssManifests(Collection<ListMssManifestConfiguration> mssManifests) {
            this.mssManifests = ListMssManifestsCopier.copy(mssManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mssManifests(ListMssManifestConfiguration... mssManifests) {
            mssManifests(Arrays.asList(mssManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mssManifests(Consumer<ListMssManifestConfiguration.Builder>... mssManifests) {
            mssManifests(Stream.of(mssManifests).map(c -> ListMssManifestConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ForceEndpointErrorConfiguration.Builder getForceEndpointErrorConfiguration() {
            return forceEndpointErrorConfiguration != null ? forceEndpointErrorConfiguration.toBuilder() : null;
        }

        public final void setForceEndpointErrorConfiguration(
                ForceEndpointErrorConfiguration.BuilderImpl forceEndpointErrorConfiguration) {
            this.forceEndpointErrorConfiguration = forceEndpointErrorConfiguration != null ? forceEndpointErrorConfiguration
                    .build() : null;
        }

        @Override
        public final Builder forceEndpointErrorConfiguration(ForceEndpointErrorConfiguration forceEndpointErrorConfiguration) {
            this.forceEndpointErrorConfiguration = forceEndpointErrorConfiguration;
            return this;
        }

        @Override
        public OriginEndpointListConfiguration build() {
            return new OriginEndpointListConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
