/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For use with DVB-DASH profiles only. The settings for error reporting from the playback device that you want
 * Elemental MediaPackage to pass through to the manifest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashDvbMetricsReporting implements SdkPojo, Serializable,
        ToCopyableBuilder<DashDvbMetricsReporting.Builder, DashDvbMetricsReporting> {
    private static final SdkField<String> REPORTING_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportingUrl").getter(getter(DashDvbMetricsReporting::reportingUrl))
            .setter(setter(Builder::reportingUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportingUrl").build()).build();

    private static final SdkField<Integer> PROBABILITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Probability").getter(getter(DashDvbMetricsReporting::probability)).setter(setter(Builder::probability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Probability").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORTING_URL_FIELD,
            PROBABILITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reportingUrl;

    private final Integer probability;

    private DashDvbMetricsReporting(BuilderImpl builder) {
        this.reportingUrl = builder.reportingUrl;
        this.probability = builder.probability;
    }

    /**
     * <p>
     * The URL where playback devices send error reports.
     * </p>
     * 
     * @return The URL where playback devices send error reports.
     */
    public final String reportingUrl() {
        return reportingUrl;
    }

    /**
     * <p>
     * The number of playback devices per 1000 that will send error reports to the reporting URL. This represents the
     * probability that a playback device will be a reporting player for this session.
     * </p>
     * 
     * @return The number of playback devices per 1000 that will send error reports to the reporting URL. This
     *         represents the probability that a playback device will be a reporting player for this session.
     */
    public final Integer probability() {
        return probability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reportingUrl());
        hashCode = 31 * hashCode + Objects.hashCode(probability());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashDvbMetricsReporting)) {
            return false;
        }
        DashDvbMetricsReporting other = (DashDvbMetricsReporting) obj;
        return Objects.equals(reportingUrl(), other.reportingUrl()) && Objects.equals(probability(), other.probability());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashDvbMetricsReporting").add("ReportingUrl", reportingUrl()).add("Probability", probability())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportingUrl":
            return Optional.ofNullable(clazz.cast(reportingUrl()));
        case "Probability":
            return Optional.ofNullable(clazz.cast(probability()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReportingUrl", REPORTING_URL_FIELD);
        map.put("Probability", PROBABILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DashDvbMetricsReporting, T> g) {
        return obj -> g.apply((DashDvbMetricsReporting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashDvbMetricsReporting> {
        /**
         * <p>
         * The URL where playback devices send error reports.
         * </p>
         * 
         * @param reportingUrl
         *        The URL where playback devices send error reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportingUrl(String reportingUrl);

        /**
         * <p>
         * The number of playback devices per 1000 that will send error reports to the reporting URL. This represents
         * the probability that a playback device will be a reporting player for this session.
         * </p>
         * 
         * @param probability
         *        The number of playback devices per 1000 that will send error reports to the reporting URL. This
         *        represents the probability that a playback device will be a reporting player for this session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder probability(Integer probability);
    }

    static final class BuilderImpl implements Builder {
        private String reportingUrl;

        private Integer probability;

        private BuilderImpl() {
        }

        private BuilderImpl(DashDvbMetricsReporting model) {
            reportingUrl(model.reportingUrl);
            probability(model.probability);
        }

        public final String getReportingUrl() {
            return reportingUrl;
        }

        public final void setReportingUrl(String reportingUrl) {
            this.reportingUrl = reportingUrl;
        }

        @Override
        public final Builder reportingUrl(String reportingUrl) {
            this.reportingUrl = reportingUrl;
            return this;
        }

        public final Integer getProbability() {
            return probability;
        }

        public final void setProbability(Integer probability) {
            this.probability = probability;
        }

        @Override
        public final Builder probability(Integer probability) {
            this.probability = probability;
            return this;
        }

        @Override
        public DashDvbMetricsReporting build() {
            return new DashDvbMetricsReporting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
