/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For use with DVB-DASH profiles only. The settings for font downloads that you want Elemental MediaPackage to pass
 * through to the manifest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashDvbFontDownload implements SdkPojo, Serializable,
        ToCopyableBuilder<DashDvbFontDownload.Builder, DashDvbFontDownload> {
    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(DashDvbFontDownload::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> MIME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MimeType").getter(getter(DashDvbFontDownload::mimeType)).setter(setter(Builder::mimeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MimeType").build()).build();

    private static final SdkField<String> FONT_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FontFamily").getter(getter(DashDvbFontDownload::fontFamily)).setter(setter(Builder::fontFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontFamily").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, MIME_TYPE_FIELD,
            FONT_FAMILY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String url;

    private final String mimeType;

    private final String fontFamily;

    private DashDvbFontDownload(BuilderImpl builder) {
        this.url = builder.url;
        this.mimeType = builder.mimeType;
        this.fontFamily = builder.fontFamily;
    }

    /**
     * <p>
     * The URL for downloading fonts for subtitles.
     * </p>
     * 
     * @return The URL for downloading fonts for subtitles.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The <code>mimeType</code> of the resource that's at the font download URL.
     * </p>
     * <p>
     * For information about font MIME types, see the <a href=
     * "https://dvb.org/wp-content/uploads/2021/06/A168r4_MPEG-DASH-Profile-for-Transport-of-ISO-BMFF-Based-DVB-Services_Draft-ts_103-285-v140_November_2021.pdf"
     * >MPEG-DASH Profile for Transport of ISO BMFF Based DVB Services over IP Based Networks</a> document.
     * </p>
     * 
     * @return The <code>mimeType</code> of the resource that's at the font download URL.</p>
     *         <p>
     *         For information about font MIME types, see the <a href=
     *         "https://dvb.org/wp-content/uploads/2021/06/A168r4_MPEG-DASH-Profile-for-Transport-of-ISO-BMFF-Based-DVB-Services_Draft-ts_103-285-v140_November_2021.pdf"
     *         >MPEG-DASH Profile for Transport of ISO BMFF Based DVB Services over IP Based Networks</a> document.
     */
    public final String mimeType() {
        return mimeType;
    }

    /**
     * <p>
     * The <code>fontFamily</code> name for subtitles, as described in <a
     * href="https://tech.ebu.ch/publications/tech3380">EBU-TT-D Subtitling Distribution Format</a>.
     * </p>
     * 
     * @return The <code>fontFamily</code> name for subtitles, as described in <a
     *         href="https://tech.ebu.ch/publications/tech3380">EBU-TT-D Subtitling Distribution Format</a>.
     */
    public final String fontFamily() {
        return fontFamily;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(mimeType());
        hashCode = 31 * hashCode + Objects.hashCode(fontFamily());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashDvbFontDownload)) {
            return false;
        }
        DashDvbFontDownload other = (DashDvbFontDownload) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(mimeType(), other.mimeType())
                && Objects.equals(fontFamily(), other.fontFamily());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashDvbFontDownload").add("Url", url()).add("MimeType", mimeType())
                .add("FontFamily", fontFamily()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "MimeType":
            return Optional.ofNullable(clazz.cast(mimeType()));
        case "FontFamily":
            return Optional.ofNullable(clazz.cast(fontFamily()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Url", URL_FIELD);
        map.put("MimeType", MIME_TYPE_FIELD);
        map.put("FontFamily", FONT_FAMILY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DashDvbFontDownload, T> g) {
        return obj -> g.apply((DashDvbFontDownload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashDvbFontDownload> {
        /**
         * <p>
         * The URL for downloading fonts for subtitles.
         * </p>
         * 
         * @param url
         *        The URL for downloading fonts for subtitles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The <code>mimeType</code> of the resource that's at the font download URL.
         * </p>
         * <p>
         * For information about font MIME types, see the <a href=
         * "https://dvb.org/wp-content/uploads/2021/06/A168r4_MPEG-DASH-Profile-for-Transport-of-ISO-BMFF-Based-DVB-Services_Draft-ts_103-285-v140_November_2021.pdf"
         * >MPEG-DASH Profile for Transport of ISO BMFF Based DVB Services over IP Based Networks</a> document.
         * </p>
         * 
         * @param mimeType
         *        The <code>mimeType</code> of the resource that's at the font download URL.</p>
         *        <p>
         *        For information about font MIME types, see the <a href=
         *        "https://dvb.org/wp-content/uploads/2021/06/A168r4_MPEG-DASH-Profile-for-Transport-of-ISO-BMFF-Based-DVB-Services_Draft-ts_103-285-v140_November_2021.pdf"
         *        >MPEG-DASH Profile for Transport of ISO BMFF Based DVB Services over IP Based Networks</a> document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mimeType(String mimeType);

        /**
         * <p>
         * The <code>fontFamily</code> name for subtitles, as described in <a
         * href="https://tech.ebu.ch/publications/tech3380">EBU-TT-D Subtitling Distribution Format</a>.
         * </p>
         * 
         * @param fontFamily
         *        The <code>fontFamily</code> name for subtitles, as described in <a
         *        href="https://tech.ebu.ch/publications/tech3380">EBU-TT-D Subtitling Distribution Format</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontFamily(String fontFamily);
    }

    static final class BuilderImpl implements Builder {
        private String url;

        private String mimeType;

        private String fontFamily;

        private BuilderImpl() {
        }

        private BuilderImpl(DashDvbFontDownload model) {
            url(model.url);
            mimeType(model.mimeType);
            fontFamily(model.fontFamily);
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getMimeType() {
            return mimeType;
        }

        public final void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public final Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public final String getFontFamily() {
            return fontFamily;
        }

        public final void setFontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
        }

        @Override
        public final Builder fontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
            return this;
        }

        @Override
        public DashDvbFontDownload build() {
            return new DashDvbFontDownload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
