/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackagev2.model.FilterConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.MssManifestLayout;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMssManifestConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateMssManifestConfiguration> {
    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestName").getter(CreateMssManifestConfiguration.getter(CreateMssManifestConfiguration::manifestName)).setter(CreateMssManifestConfiguration.setter(Builder::manifestName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestName").build()}).build();
    private static final SdkField<Integer> MANIFEST_WINDOW_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ManifestWindowSeconds").getter(CreateMssManifestConfiguration.getter(CreateMssManifestConfiguration::manifestWindowSeconds)).setter(CreateMssManifestConfiguration.setter(Builder::manifestWindowSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestWindowSeconds").build()}).build();
    private static final SdkField<FilterConfiguration> FILTER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterConfiguration").getter(CreateMssManifestConfiguration.getter(CreateMssManifestConfiguration::filterConfiguration)).setter(CreateMssManifestConfiguration.setter(Builder::filterConfiguration)).constructor(FilterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterConfiguration").build()}).build();
    private static final SdkField<String> MANIFEST_LAYOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestLayout").getter(CreateMssManifestConfiguration.getter(CreateMssManifestConfiguration::manifestLayoutAsString)).setter(CreateMssManifestConfiguration.setter(Builder::manifestLayout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestLayout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_NAME_FIELD, MANIFEST_WINDOW_SECONDS_FIELD, FILTER_CONFIGURATION_FIELD, MANIFEST_LAYOUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMssManifestConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String manifestName;
    private final Integer manifestWindowSeconds;
    private final FilterConfiguration filterConfiguration;
    private final String manifestLayout;

    private CreateMssManifestConfiguration(BuilderImpl builder) {
        this.manifestName = builder.manifestName;
        this.manifestWindowSeconds = builder.manifestWindowSeconds;
        this.filterConfiguration = builder.filterConfiguration;
        this.manifestLayout = builder.manifestLayout;
    }

    public final String manifestName() {
        return this.manifestName;
    }

    public final Integer manifestWindowSeconds() {
        return this.manifestWindowSeconds;
    }

    public final FilterConfiguration filterConfiguration() {
        return this.filterConfiguration;
    }

    public final MssManifestLayout manifestLayout() {
        return MssManifestLayout.fromValue(this.manifestLayout);
    }

    public final String manifestLayoutAsString() {
        return this.manifestLayout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestLayoutAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMssManifestConfiguration)) {
            return false;
        }
        CreateMssManifestConfiguration other = (CreateMssManifestConfiguration)obj;
        return Objects.equals(this.manifestName(), other.manifestName()) && Objects.equals(this.manifestWindowSeconds(), other.manifestWindowSeconds()) && Objects.equals(this.filterConfiguration(), other.filterConfiguration()) && Objects.equals(this.manifestLayoutAsString(), other.manifestLayoutAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMssManifestConfiguration").add("ManifestName", (Object)this.manifestName()).add("ManifestWindowSeconds", (Object)this.manifestWindowSeconds()).add("FilterConfiguration", (Object)this.filterConfiguration()).add("ManifestLayout", (Object)this.manifestLayoutAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManifestName": {
                return Optional.ofNullable(clazz.cast(this.manifestName()));
            }
            case "ManifestWindowSeconds": {
                return Optional.ofNullable(clazz.cast(this.manifestWindowSeconds()));
            }
            case "FilterConfiguration": {
                return Optional.ofNullable(clazz.cast(this.filterConfiguration()));
            }
            case "ManifestLayout": {
                return Optional.ofNullable(clazz.cast(this.manifestLayoutAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ManifestName", MANIFEST_NAME_FIELD);
        map.put("ManifestWindowSeconds", MANIFEST_WINDOW_SECONDS_FIELD);
        map.put("FilterConfiguration", FILTER_CONFIGURATION_FIELD);
        map.put("ManifestLayout", MANIFEST_LAYOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMssManifestConfiguration, T> g) {
        return obj -> g.apply((CreateMssManifestConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String manifestName;
        private Integer manifestWindowSeconds;
        private FilterConfiguration filterConfiguration;
        private String manifestLayout;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMssManifestConfiguration model) {
            this.manifestName(model.manifestName);
            this.manifestWindowSeconds(model.manifestWindowSeconds);
            this.filterConfiguration(model.filterConfiguration);
            this.manifestLayout(model.manifestLayout);
        }

        public final String getManifestName() {
            return this.manifestName;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final Integer getManifestWindowSeconds() {
            return this.manifestWindowSeconds;
        }

        public final void setManifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
        }

        @Override
        public final Builder manifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
            return this;
        }

        public final FilterConfiguration.Builder getFilterConfiguration() {
            return this.filterConfiguration != null ? this.filterConfiguration.toBuilder() : null;
        }

        public final void setFilterConfiguration(FilterConfiguration.BuilderImpl filterConfiguration) {
            this.filterConfiguration = filterConfiguration != null ? filterConfiguration.build() : null;
        }

        @Override
        public final Builder filterConfiguration(FilterConfiguration filterConfiguration) {
            this.filterConfiguration = filterConfiguration;
            return this;
        }

        public final String getManifestLayout() {
            return this.manifestLayout;
        }

        public final void setManifestLayout(String manifestLayout) {
            this.manifestLayout = manifestLayout;
        }

        @Override
        public final Builder manifestLayout(String manifestLayout) {
            this.manifestLayout = manifestLayout;
            return this;
        }

        @Override
        public final Builder manifestLayout(MssManifestLayout manifestLayout) {
            this.manifestLayout(manifestLayout == null ? null : manifestLayout.toString());
            return this;
        }

        public CreateMssManifestConfiguration build() {
            return new CreateMssManifestConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateMssManifestConfiguration> {
        public Builder manifestName(String var1);

        public Builder manifestWindowSeconds(Integer var1);

        public Builder filterConfiguration(FilterConfiguration var1);

        default public Builder filterConfiguration(Consumer<FilterConfiguration.Builder> filterConfiguration) {
            return this.filterConfiguration((FilterConfiguration)((FilterConfiguration.Builder)FilterConfiguration.builder().applyMutation(filterConfiguration)).build());
        }

        public Builder manifestLayout(String var1);

        public Builder manifestLayout(MssManifestLayout var1);
    }
}

