/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackagev2.model.DashDrmSignaling;
import software.amazon.awssdk.services.mediapackagev2.model.DashPeriodTrigger;
import software.amazon.awssdk.services.mediapackagev2.model.DashPeriodTriggersCopier;
import software.amazon.awssdk.services.mediapackagev2.model.DashSegmentTemplateFormat;
import software.amazon.awssdk.services.mediapackagev2.model.DashUtcTiming;
import software.amazon.awssdk.services.mediapackagev2.model.FilterConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.ScteDash;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDashManifestConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GetDashManifestConfiguration> {
    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestName").getter(GetDashManifestConfiguration.getter(GetDashManifestConfiguration::manifestName)).setter(GetDashManifestConfiguration.setter(Builder::manifestName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestName").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(GetDashManifestConfiguration.getter(GetDashManifestConfiguration::url)).setter(GetDashManifestConfiguration.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<Integer> MANIFEST_WINDOW_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ManifestWindowSeconds").getter(GetDashManifestConfiguration.getter(GetDashManifestConfiguration::manifestWindowSeconds)).setter(GetDashManifestConfiguration.setter(Builder::manifestWindowSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestWindowSeconds").build()}).build();
    private static final SdkField<FilterConfiguration> FILTER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterConfiguration").getter(GetDashManifestConfiguration.getter(GetDashManifestConfiguration::filterConfiguration)).setter(GetDashManifestConfiguration.setter(Builder::filterConfiguration)).constructor(FilterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterConfiguration").build()}).build();
    private static final SdkField<Integer> MIN_UPDATE_PERIOD_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinUpdatePeriodSeconds").getter(GetDashManifestConfiguration.getter(GetDashManifestConfiguration::minUpdatePeriodSeconds)).setter(GetDashManifestConfiguration.setter(Builder::minUpdatePeriodSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinUpdatePeriodSeconds").build()}).build();
    private static final SdkField<Integer> MIN_BUFFER_TIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinBufferTimeSeconds").getter(GetDashManifestConfiguration.getter(GetDashManifestConfiguration::minBufferTimeSeconds)).setter(GetDashManifestConfiguration.setter(Builder::minBufferTimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinBufferTimeSeconds").build()}).build();
    private static final SdkField<Integer> SUGGESTED_PRESENTATION_DELAY_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SuggestedPresentationDelaySeconds").getter(GetDashManifestConfiguration.getter(GetDashManifestConfiguration::suggestedPresentationDelaySeconds)).setter(GetDashManifestConfiguration.setter(Builder::suggestedPresentationDelaySeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestedPresentationDelaySeconds").build()}).build();
    private static final SdkField<String> SEGMENT_TEMPLATE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentTemplateFormat").getter(GetDashManifestConfiguration.getter(GetDashManifestConfiguration::segmentTemplateFormatAsString)).setter(GetDashManifestConfiguration.setter(Builder::segmentTemplateFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentTemplateFormat").build()}).build();
    private static final SdkField<List<String>> PERIOD_TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PeriodTriggers").getter(GetDashManifestConfiguration.getter(GetDashManifestConfiguration::periodTriggersAsStrings)).setter(GetDashManifestConfiguration.setter(Builder::periodTriggersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodTriggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ScteDash> SCTE_DASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScteDash").getter(GetDashManifestConfiguration.getter(GetDashManifestConfiguration::scteDash)).setter(GetDashManifestConfiguration.setter(Builder::scteDash)).constructor(ScteDash::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScteDash").build()}).build();
    private static final SdkField<String> DRM_SIGNALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DrmSignaling").getter(GetDashManifestConfiguration.getter(GetDashManifestConfiguration::drmSignalingAsString)).setter(GetDashManifestConfiguration.setter(Builder::drmSignaling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DrmSignaling").build()}).build();
    private static final SdkField<DashUtcTiming> UTC_TIMING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UtcTiming").getter(GetDashManifestConfiguration.getter(GetDashManifestConfiguration::utcTiming)).setter(GetDashManifestConfiguration.setter(Builder::utcTiming)).constructor(DashUtcTiming::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtcTiming").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_NAME_FIELD, URL_FIELD, MANIFEST_WINDOW_SECONDS_FIELD, FILTER_CONFIGURATION_FIELD, MIN_UPDATE_PERIOD_SECONDS_FIELD, MIN_BUFFER_TIME_SECONDS_FIELD, SUGGESTED_PRESENTATION_DELAY_SECONDS_FIELD, SEGMENT_TEMPLATE_FORMAT_FIELD, PERIOD_TRIGGERS_FIELD, SCTE_DASH_FIELD, DRM_SIGNALING_FIELD, UTC_TIMING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDashManifestConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String manifestName;
    private final String url;
    private final Integer manifestWindowSeconds;
    private final FilterConfiguration filterConfiguration;
    private final Integer minUpdatePeriodSeconds;
    private final Integer minBufferTimeSeconds;
    private final Integer suggestedPresentationDelaySeconds;
    private final String segmentTemplateFormat;
    private final List<String> periodTriggers;
    private final ScteDash scteDash;
    private final String drmSignaling;
    private final DashUtcTiming utcTiming;

    private GetDashManifestConfiguration(BuilderImpl builder) {
        this.manifestName = builder.manifestName;
        this.url = builder.url;
        this.manifestWindowSeconds = builder.manifestWindowSeconds;
        this.filterConfiguration = builder.filterConfiguration;
        this.minUpdatePeriodSeconds = builder.minUpdatePeriodSeconds;
        this.minBufferTimeSeconds = builder.minBufferTimeSeconds;
        this.suggestedPresentationDelaySeconds = builder.suggestedPresentationDelaySeconds;
        this.segmentTemplateFormat = builder.segmentTemplateFormat;
        this.periodTriggers = builder.periodTriggers;
        this.scteDash = builder.scteDash;
        this.drmSignaling = builder.drmSignaling;
        this.utcTiming = builder.utcTiming;
    }

    public final String manifestName() {
        return this.manifestName;
    }

    public final String url() {
        return this.url;
    }

    public final Integer manifestWindowSeconds() {
        return this.manifestWindowSeconds;
    }

    public final FilterConfiguration filterConfiguration() {
        return this.filterConfiguration;
    }

    public final Integer minUpdatePeriodSeconds() {
        return this.minUpdatePeriodSeconds;
    }

    public final Integer minBufferTimeSeconds() {
        return this.minBufferTimeSeconds;
    }

    public final Integer suggestedPresentationDelaySeconds() {
        return this.suggestedPresentationDelaySeconds;
    }

    public final DashSegmentTemplateFormat segmentTemplateFormat() {
        return DashSegmentTemplateFormat.fromValue(this.segmentTemplateFormat);
    }

    public final String segmentTemplateFormatAsString() {
        return this.segmentTemplateFormat;
    }

    public final List<DashPeriodTrigger> periodTriggers() {
        return DashPeriodTriggersCopier.copyStringToEnum(this.periodTriggers);
    }

    public final boolean hasPeriodTriggers() {
        return this.periodTriggers != null && !(this.periodTriggers instanceof SdkAutoConstructList);
    }

    public final List<String> periodTriggersAsStrings() {
        return this.periodTriggers;
    }

    public final ScteDash scteDash() {
        return this.scteDash;
    }

    public final DashDrmSignaling drmSignaling() {
        return DashDrmSignaling.fromValue(this.drmSignaling);
    }

    public final String drmSignalingAsString() {
        return this.drmSignaling;
    }

    public final DashUtcTiming utcTiming() {
        return this.utcTiming;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.minUpdatePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.minBufferTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.suggestedPresentationDelaySeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentTemplateFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPeriodTriggers() ? this.periodTriggersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scteDash());
        hashCode = 31 * hashCode + Objects.hashCode(this.drmSignalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.utcTiming());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDashManifestConfiguration)) {
            return false;
        }
        GetDashManifestConfiguration other = (GetDashManifestConfiguration)obj;
        return Objects.equals(this.manifestName(), other.manifestName()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.manifestWindowSeconds(), other.manifestWindowSeconds()) && Objects.equals(this.filterConfiguration(), other.filterConfiguration()) && Objects.equals(this.minUpdatePeriodSeconds(), other.minUpdatePeriodSeconds()) && Objects.equals(this.minBufferTimeSeconds(), other.minBufferTimeSeconds()) && Objects.equals(this.suggestedPresentationDelaySeconds(), other.suggestedPresentationDelaySeconds()) && Objects.equals(this.segmentTemplateFormatAsString(), other.segmentTemplateFormatAsString()) && this.hasPeriodTriggers() == other.hasPeriodTriggers() && Objects.equals(this.periodTriggersAsStrings(), other.periodTriggersAsStrings()) && Objects.equals(this.scteDash(), other.scteDash()) && Objects.equals(this.drmSignalingAsString(), other.drmSignalingAsString()) && Objects.equals(this.utcTiming(), other.utcTiming());
    }

    public final String toString() {
        return ToString.builder((String)"GetDashManifestConfiguration").add("ManifestName", (Object)this.manifestName()).add("Url", (Object)this.url()).add("ManifestWindowSeconds", (Object)this.manifestWindowSeconds()).add("FilterConfiguration", (Object)this.filterConfiguration()).add("MinUpdatePeriodSeconds", (Object)this.minUpdatePeriodSeconds()).add("MinBufferTimeSeconds", (Object)this.minBufferTimeSeconds()).add("SuggestedPresentationDelaySeconds", (Object)this.suggestedPresentationDelaySeconds()).add("SegmentTemplateFormat", (Object)this.segmentTemplateFormatAsString()).add("PeriodTriggers", this.hasPeriodTriggers() ? this.periodTriggersAsStrings() : null).add("ScteDash", (Object)this.scteDash()).add("DrmSignaling", (Object)this.drmSignalingAsString()).add("UtcTiming", (Object)this.utcTiming()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManifestName": {
                return Optional.ofNullable(clazz.cast(this.manifestName()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "ManifestWindowSeconds": {
                return Optional.ofNullable(clazz.cast(this.manifestWindowSeconds()));
            }
            case "FilterConfiguration": {
                return Optional.ofNullable(clazz.cast(this.filterConfiguration()));
            }
            case "MinUpdatePeriodSeconds": {
                return Optional.ofNullable(clazz.cast(this.minUpdatePeriodSeconds()));
            }
            case "MinBufferTimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.minBufferTimeSeconds()));
            }
            case "SuggestedPresentationDelaySeconds": {
                return Optional.ofNullable(clazz.cast(this.suggestedPresentationDelaySeconds()));
            }
            case "SegmentTemplateFormat": {
                return Optional.ofNullable(clazz.cast(this.segmentTemplateFormatAsString()));
            }
            case "PeriodTriggers": {
                return Optional.ofNullable(clazz.cast(this.periodTriggersAsStrings()));
            }
            case "ScteDash": {
                return Optional.ofNullable(clazz.cast(this.scteDash()));
            }
            case "DrmSignaling": {
                return Optional.ofNullable(clazz.cast(this.drmSignalingAsString()));
            }
            case "UtcTiming": {
                return Optional.ofNullable(clazz.cast(this.utcTiming()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ManifestName", MANIFEST_NAME_FIELD);
        map.put("Url", URL_FIELD);
        map.put("ManifestWindowSeconds", MANIFEST_WINDOW_SECONDS_FIELD);
        map.put("FilterConfiguration", FILTER_CONFIGURATION_FIELD);
        map.put("MinUpdatePeriodSeconds", MIN_UPDATE_PERIOD_SECONDS_FIELD);
        map.put("MinBufferTimeSeconds", MIN_BUFFER_TIME_SECONDS_FIELD);
        map.put("SuggestedPresentationDelaySeconds", SUGGESTED_PRESENTATION_DELAY_SECONDS_FIELD);
        map.put("SegmentTemplateFormat", SEGMENT_TEMPLATE_FORMAT_FIELD);
        map.put("PeriodTriggers", PERIOD_TRIGGERS_FIELD);
        map.put("ScteDash", SCTE_DASH_FIELD);
        map.put("DrmSignaling", DRM_SIGNALING_FIELD);
        map.put("UtcTiming", UTC_TIMING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDashManifestConfiguration, T> g) {
        return obj -> g.apply((GetDashManifestConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String manifestName;
        private String url;
        private Integer manifestWindowSeconds;
        private FilterConfiguration filterConfiguration;
        private Integer minUpdatePeriodSeconds;
        private Integer minBufferTimeSeconds;
        private Integer suggestedPresentationDelaySeconds;
        private String segmentTemplateFormat;
        private List<String> periodTriggers = DefaultSdkAutoConstructList.getInstance();
        private ScteDash scteDash;
        private String drmSignaling;
        private DashUtcTiming utcTiming;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDashManifestConfiguration model) {
            this.manifestName(model.manifestName);
            this.url(model.url);
            this.manifestWindowSeconds(model.manifestWindowSeconds);
            this.filterConfiguration(model.filterConfiguration);
            this.minUpdatePeriodSeconds(model.minUpdatePeriodSeconds);
            this.minBufferTimeSeconds(model.minBufferTimeSeconds);
            this.suggestedPresentationDelaySeconds(model.suggestedPresentationDelaySeconds);
            this.segmentTemplateFormat(model.segmentTemplateFormat);
            this.periodTriggersWithStrings(model.periodTriggers);
            this.scteDash(model.scteDash);
            this.drmSignaling(model.drmSignaling);
            this.utcTiming(model.utcTiming);
        }

        public final String getManifestName() {
            return this.manifestName;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final Integer getManifestWindowSeconds() {
            return this.manifestWindowSeconds;
        }

        public final void setManifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
        }

        @Override
        public final Builder manifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
            return this;
        }

        public final FilterConfiguration.Builder getFilterConfiguration() {
            return this.filterConfiguration != null ? this.filterConfiguration.toBuilder() : null;
        }

        public final void setFilterConfiguration(FilterConfiguration.BuilderImpl filterConfiguration) {
            this.filterConfiguration = filterConfiguration != null ? filterConfiguration.build() : null;
        }

        @Override
        public final Builder filterConfiguration(FilterConfiguration filterConfiguration) {
            this.filterConfiguration = filterConfiguration;
            return this;
        }

        public final Integer getMinUpdatePeriodSeconds() {
            return this.minUpdatePeriodSeconds;
        }

        public final void setMinUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
            this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
        }

        @Override
        public final Builder minUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
            this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
            return this;
        }

        public final Integer getMinBufferTimeSeconds() {
            return this.minBufferTimeSeconds;
        }

        public final void setMinBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
        }

        @Override
        public final Builder minBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
            return this;
        }

        public final Integer getSuggestedPresentationDelaySeconds() {
            return this.suggestedPresentationDelaySeconds;
        }

        public final void setSuggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
            this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
        }

        @Override
        public final Builder suggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
            this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
            return this;
        }

        public final String getSegmentTemplateFormat() {
            return this.segmentTemplateFormat;
        }

        public final void setSegmentTemplateFormat(String segmentTemplateFormat) {
            this.segmentTemplateFormat = segmentTemplateFormat;
        }

        @Override
        public final Builder segmentTemplateFormat(String segmentTemplateFormat) {
            this.segmentTemplateFormat = segmentTemplateFormat;
            return this;
        }

        @Override
        public final Builder segmentTemplateFormat(DashSegmentTemplateFormat segmentTemplateFormat) {
            this.segmentTemplateFormat(segmentTemplateFormat == null ? null : segmentTemplateFormat.toString());
            return this;
        }

        public final Collection<String> getPeriodTriggers() {
            if (this.periodTriggers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.periodTriggers;
        }

        public final void setPeriodTriggers(Collection<String> periodTriggers) {
            this.periodTriggers = DashPeriodTriggersCopier.copy(periodTriggers);
        }

        @Override
        public final Builder periodTriggersWithStrings(Collection<String> periodTriggers) {
            this.periodTriggers = DashPeriodTriggersCopier.copy(periodTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodTriggersWithStrings(String ... periodTriggers) {
            this.periodTriggersWithStrings(Arrays.asList(periodTriggers));
            return this;
        }

        @Override
        public final Builder periodTriggers(Collection<DashPeriodTrigger> periodTriggers) {
            this.periodTriggers = DashPeriodTriggersCopier.copyEnumToString(periodTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodTriggers(DashPeriodTrigger ... periodTriggers) {
            this.periodTriggers(Arrays.asList(periodTriggers));
            return this;
        }

        public final ScteDash.Builder getScteDash() {
            return this.scteDash != null ? this.scteDash.toBuilder() : null;
        }

        public final void setScteDash(ScteDash.BuilderImpl scteDash) {
            this.scteDash = scteDash != null ? scteDash.build() : null;
        }

        @Override
        public final Builder scteDash(ScteDash scteDash) {
            this.scteDash = scteDash;
            return this;
        }

        public final String getDrmSignaling() {
            return this.drmSignaling;
        }

        public final void setDrmSignaling(String drmSignaling) {
            this.drmSignaling = drmSignaling;
        }

        @Override
        public final Builder drmSignaling(String drmSignaling) {
            this.drmSignaling = drmSignaling;
            return this;
        }

        @Override
        public final Builder drmSignaling(DashDrmSignaling drmSignaling) {
            this.drmSignaling(drmSignaling == null ? null : drmSignaling.toString());
            return this;
        }

        public final DashUtcTiming.Builder getUtcTiming() {
            return this.utcTiming != null ? this.utcTiming.toBuilder() : null;
        }

        public final void setUtcTiming(DashUtcTiming.BuilderImpl utcTiming) {
            this.utcTiming = utcTiming != null ? utcTiming.build() : null;
        }

        @Override
        public final Builder utcTiming(DashUtcTiming utcTiming) {
            this.utcTiming = utcTiming;
            return this;
        }

        public GetDashManifestConfiguration build() {
            return new GetDashManifestConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GetDashManifestConfiguration> {
        public Builder manifestName(String var1);

        public Builder url(String var1);

        public Builder manifestWindowSeconds(Integer var1);

        public Builder filterConfiguration(FilterConfiguration var1);

        default public Builder filterConfiguration(Consumer<FilterConfiguration.Builder> filterConfiguration) {
            return this.filterConfiguration((FilterConfiguration)((FilterConfiguration.Builder)FilterConfiguration.builder().applyMutation(filterConfiguration)).build());
        }

        public Builder minUpdatePeriodSeconds(Integer var1);

        public Builder minBufferTimeSeconds(Integer var1);

        public Builder suggestedPresentationDelaySeconds(Integer var1);

        public Builder segmentTemplateFormat(String var1);

        public Builder segmentTemplateFormat(DashSegmentTemplateFormat var1);

        public Builder periodTriggersWithStrings(Collection<String> var1);

        public Builder periodTriggersWithStrings(String ... var1);

        public Builder periodTriggers(Collection<DashPeriodTrigger> var1);

        public Builder periodTriggers(DashPeriodTrigger ... var1);

        public Builder scteDash(ScteDash var1);

        default public Builder scteDash(Consumer<ScteDash.Builder> scteDash) {
            return this.scteDash((ScteDash)((ScteDash.Builder)ScteDash.builder().applyMutation(scteDash)).build());
        }

        public Builder drmSignaling(String var1);

        public Builder drmSignaling(DashDrmSignaling var1);

        public Builder utcTiming(DashUtcTiming var1);

        default public Builder utcTiming(Consumer<DashUtcTiming.Builder> utcTiming) {
            return this.utcTiming((DashUtcTiming)((DashUtcTiming.Builder)DashUtcTiming.builder().applyMutation(utcTiming)).build());
        }
    }
}

