/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DrmSystem {
    CLEAR_KEY_AES_128("CLEAR_KEY_AES_128"),
    FAIRPLAY("FAIRPLAY"),
    PLAYREADY("PLAYREADY"),
    WIDEVINE("WIDEVINE"),
    IRDETO("IRDETO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DrmSystem> VALUE_MAP;
    private final String value;

    private DrmSystem(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DrmSystem fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DrmSystem> knownValues() {
        EnumSet<DrmSystem> knownValues = EnumSet.allOf(DrmSystem.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DrmSystem.class, DrmSystem::toString);
    }
}

