/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediapackagev2.model.Destination;
import software.amazon.awssdk.services.mediapackagev2.model.HarvestedManifests;
import software.amazon.awssdk.services.mediapackagev2.model.HarvesterScheduleConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.MediaPackageV2Request;
import software.amazon.awssdk.services.mediapackagev2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHarvestJobRequest
extends MediaPackageV2Request
implements ToCopyableBuilder<Builder, CreateHarvestJobRequest> {
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelGroupName").getter(CreateHarvestJobRequest.getter(CreateHarvestJobRequest::channelGroupName)).setter(CreateHarvestJobRequest.setter(Builder::channelGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelGroupName").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(CreateHarvestJobRequest.getter(CreateHarvestJobRequest::channelName)).setter(CreateHarvestJobRequest.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelName").build()}).build();
    private static final SdkField<String> ORIGIN_ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginEndpointName").getter(CreateHarvestJobRequest.getter(CreateHarvestJobRequest::originEndpointName)).setter(CreateHarvestJobRequest.setter(Builder::originEndpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("OriginEndpointName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateHarvestJobRequest.getter(CreateHarvestJobRequest::description)).setter(CreateHarvestJobRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<HarvestedManifests> HARVESTED_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HarvestedManifests").getter(CreateHarvestJobRequest.getter(CreateHarvestJobRequest::harvestedManifests)).setter(CreateHarvestJobRequest.setter(Builder::harvestedManifests)).constructor(HarvestedManifests::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HarvestedManifests").build()}).build();
    private static final SdkField<HarvesterScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScheduleConfiguration").getter(CreateHarvestJobRequest.getter(CreateHarvestJobRequest::scheduleConfiguration)).setter(CreateHarvestJobRequest.setter(Builder::scheduleConfiguration)).constructor(HarvesterScheduleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build()}).build();
    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(CreateHarvestJobRequest.getter(CreateHarvestJobRequest::destination)).setter(CreateHarvestJobRequest.setter(Builder::destination)).constructor(Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateHarvestJobRequest.getter(CreateHarvestJobRequest::clientToken)).setter(CreateHarvestJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-client-token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> HARVEST_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HarvestJobName").getter(CreateHarvestJobRequest.getter(CreateHarvestJobRequest::harvestJobName)).setter(CreateHarvestJobRequest.setter(Builder::harvestJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HarvestJobName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateHarvestJobRequest.getter(CreateHarvestJobRequest::tags)).setter(CreateHarvestJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_GROUP_NAME_FIELD, CHANNEL_NAME_FIELD, ORIGIN_ENDPOINT_NAME_FIELD, DESCRIPTION_FIELD, HARVESTED_MANIFESTS_FIELD, SCHEDULE_CONFIGURATION_FIELD, DESTINATION_FIELD, CLIENT_TOKEN_FIELD, HARVEST_JOB_NAME_FIELD, TAGS_FIELD));
    private final String channelGroupName;
    private final String channelName;
    private final String originEndpointName;
    private final String description;
    private final HarvestedManifests harvestedManifests;
    private final HarvesterScheduleConfiguration scheduleConfiguration;
    private final Destination destination;
    private final String clientToken;
    private final String harvestJobName;
    private final Map<String, String> tags;

    private CreateHarvestJobRequest(BuilderImpl builder) {
        super(builder);
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.originEndpointName = builder.originEndpointName;
        this.description = builder.description;
        this.harvestedManifests = builder.harvestedManifests;
        this.scheduleConfiguration = builder.scheduleConfiguration;
        this.destination = builder.destination;
        this.clientToken = builder.clientToken;
        this.harvestJobName = builder.harvestJobName;
        this.tags = builder.tags;
    }

    public final String channelGroupName() {
        return this.channelGroupName;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String originEndpointName() {
        return this.originEndpointName;
    }

    public final String description() {
        return this.description;
    }

    public final HarvestedManifests harvestedManifests() {
        return this.harvestedManifests;
    }

    public final HarvesterScheduleConfiguration scheduleConfiguration() {
        return this.scheduleConfiguration;
    }

    public final Destination destination() {
        return this.destination;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String harvestJobName() {
        return this.harvestJobName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.originEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.harvestedManifests());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.harvestJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHarvestJobRequest)) {
            return false;
        }
        CreateHarvestJobRequest other = (CreateHarvestJobRequest)((Object)obj);
        return Objects.equals(this.channelGroupName(), other.channelGroupName()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.originEndpointName(), other.originEndpointName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.harvestedManifests(), other.harvestedManifests()) && Objects.equals(this.scheduleConfiguration(), other.scheduleConfiguration()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.harvestJobName(), other.harvestJobName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateHarvestJobRequest").add("ChannelGroupName", (Object)this.channelGroupName()).add("ChannelName", (Object)this.channelName()).add("OriginEndpointName", (Object)this.originEndpointName()).add("Description", (Object)this.description()).add("HarvestedManifests", (Object)this.harvestedManifests()).add("ScheduleConfiguration", (Object)this.scheduleConfiguration()).add("Destination", (Object)this.destination()).add("ClientToken", (Object)this.clientToken()).add("HarvestJobName", (Object)this.harvestJobName()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelGroupName": {
                return Optional.ofNullable(clazz.cast(this.channelGroupName()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "OriginEndpointName": {
                return Optional.ofNullable(clazz.cast(this.originEndpointName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HarvestedManifests": {
                return Optional.ofNullable(clazz.cast(this.harvestedManifests()));
            }
            case "ScheduleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scheduleConfiguration()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "HarvestJobName": {
                return Optional.ofNullable(clazz.cast(this.harvestJobName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHarvestJobRequest, T> g) {
        return obj -> g.apply((CreateHarvestJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageV2Request.BuilderImpl
    implements Builder {
        private String channelGroupName;
        private String channelName;
        private String originEndpointName;
        private String description;
        private HarvestedManifests harvestedManifests;
        private HarvesterScheduleConfiguration scheduleConfiguration;
        private Destination destination;
        private String clientToken;
        private String harvestJobName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHarvestJobRequest model) {
            super(model);
            this.channelGroupName(model.channelGroupName);
            this.channelName(model.channelName);
            this.originEndpointName(model.originEndpointName);
            this.description(model.description);
            this.harvestedManifests(model.harvestedManifests);
            this.scheduleConfiguration(model.scheduleConfiguration);
            this.destination(model.destination);
            this.clientToken(model.clientToken);
            this.harvestJobName(model.harvestJobName);
            this.tags(model.tags);
        }

        public final String getChannelGroupName() {
            return this.channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getOriginEndpointName() {
            return this.originEndpointName;
        }

        public final void setOriginEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
        }

        @Override
        public final Builder originEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final HarvestedManifests.Builder getHarvestedManifests() {
            return this.harvestedManifests != null ? this.harvestedManifests.toBuilder() : null;
        }

        public final void setHarvestedManifests(HarvestedManifests.BuilderImpl harvestedManifests) {
            this.harvestedManifests = harvestedManifests != null ? harvestedManifests.build() : null;
        }

        @Override
        public final Builder harvestedManifests(HarvestedManifests harvestedManifests) {
            this.harvestedManifests = harvestedManifests;
            return this;
        }

        public final HarvesterScheduleConfiguration.Builder getScheduleConfiguration() {
            return this.scheduleConfiguration != null ? this.scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(HarvesterScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        public final Builder scheduleConfiguration(HarvesterScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        public final Destination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getHarvestJobName() {
            return this.harvestJobName;
        }

        public final void setHarvestJobName(String harvestJobName) {
            this.harvestJobName = harvestJobName;
        }

        @Override
        public final Builder harvestJobName(String harvestJobName) {
            this.harvestJobName = harvestJobName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHarvestJobRequest build() {
            return new CreateHarvestJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaPackageV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHarvestJobRequest> {
        public Builder channelGroupName(String var1);

        public Builder channelName(String var1);

        public Builder originEndpointName(String var1);

        public Builder description(String var1);

        public Builder harvestedManifests(HarvestedManifests var1);

        default public Builder harvestedManifests(Consumer<HarvestedManifests.Builder> harvestedManifests) {
            return this.harvestedManifests((HarvestedManifests)((HarvestedManifests.Builder)HarvestedManifests.builder().applyMutation(harvestedManifests)).build());
        }

        public Builder scheduleConfiguration(HarvesterScheduleConfiguration var1);

        default public Builder scheduleConfiguration(Consumer<HarvesterScheduleConfiguration.Builder> scheduleConfiguration) {
            return this.scheduleConfiguration((HarvesterScheduleConfiguration)((HarvesterScheduleConfiguration.Builder)HarvesterScheduleConfiguration.builder().applyMutation(scheduleConfiguration)).build());
        }

        public Builder destination(Destination var1);

        default public Builder destination(Consumer<Destination.Builder> destination) {
            return this.destination((Destination)((Destination.Builder)Destination.builder().applyMutation(destination)).build());
        }

        public Builder clientToken(String var1);

        public Builder harvestJobName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

