/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DestinationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DestinationConfig> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(S3DestinationConfig.getter(S3DestinationConfig::bucketName)).setter(S3DestinationConfig.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()}).build();
    private static final SdkField<String> DESTINATION_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPath").getter(S3DestinationConfig.getter(S3DestinationConfig::destinationPath)).setter(S3DestinationConfig.setter(Builder::destinationPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, DESTINATION_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BucketName", BUCKET_NAME_FIELD);
            this.put("DestinationPath", DESTINATION_PATH_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String destinationPath;

    private S3DestinationConfig(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.destinationPath = builder.destinationPath;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String destinationPath() {
        return this.destinationPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DestinationConfig)) {
            return false;
        }
        S3DestinationConfig other = (S3DestinationConfig)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.destinationPath(), other.destinationPath());
    }

    public final String toString() {
        return ToString.builder((String)"S3DestinationConfig").add("BucketName", (Object)this.bucketName()).add("DestinationPath", (Object)this.destinationPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "DestinationPath": {
                return Optional.ofNullable(clazz.cast(this.destinationPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3DestinationConfig, T> g) {
        return obj -> g.apply((S3DestinationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String destinationPath;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DestinationConfig model) {
            this.bucketName(model.bucketName);
            this.destinationPath(model.destinationPath);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getDestinationPath() {
            return this.destinationPath;
        }

        public final void setDestinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
        }

        @Override
        public final Builder destinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
            return this;
        }

        public S3DestinationConfig build() {
            return new S3DestinationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DestinationConfig> {
        public Builder bucketName(String var1);

        public Builder destinationPath(String var1);
    }
}

