/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.mediapackagev2.MediaPackageV2Client;
import software.amazon.awssdk.services.mediapackagev2.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.mediapackagev2.model.GetHarvestJobRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetHarvestJobResponse;
import software.amazon.awssdk.services.mediapackagev2.model.MediaPackageV2Request;
import software.amazon.awssdk.services.mediapackagev2.waiters.MediaPackageV2Waiter;
import software.amazon.awssdk.services.mediapackagev2.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultMediaPackageV2Waiter
implements MediaPackageV2Waiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final MediaPackageV2Client client;
    private final AttributeMap managedResources;
    private final Waiter<GetHarvestJobResponse> harvestJobFinishedWaiter;

    private DefaultMediaPackageV2Waiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (MediaPackageV2Client)MediaPackageV2Client.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.harvestJobFinishedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetHarvestJobResponse.class).acceptors(DefaultMediaPackageV2Waiter.harvestJobFinishedWaiterAcceptors())).overrideConfiguration(DefaultMediaPackageV2Waiter.harvestJobFinishedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetHarvestJobResponse> waitUntilHarvestJobFinished(GetHarvestJobRequest getHarvestJobRequest) {
        return this.harvestJobFinishedWaiter.run(() -> this.client.getHarvestJob(this.applyWaitersUserAgent(getHarvestJobRequest)));
    }

    @Override
    public WaiterResponse<GetHarvestJobResponse> waitUntilHarvestJobFinished(GetHarvestJobRequest getHarvestJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.harvestJobFinishedWaiter.run(() -> this.client.getHarvestJob(this.applyWaitersUserAgent(getHarvestJobRequest)), DefaultMediaPackageV2Waiter.harvestJobFinishedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetHarvestJobResponse>> harvestJobFinishedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetHarvestJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetHarvestJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "CANCELLED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "QUEUED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "IN_PROGRESS");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration harvestJobFinishedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static MediaPackageV2Waiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends MediaPackageV2Request> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((MediaPackageV2Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements MediaPackageV2Waiter.Builder {
        private MediaPackageV2Client client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public MediaPackageV2Waiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public MediaPackageV2Waiter.Builder client(MediaPackageV2Client client) {
            this.client = client;
            return this;
        }

        @Override
        public MediaPackageV2Waiter build() {
            return new DefaultMediaPackageV2Waiter(this);
        }
    }
}

