/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackagev2.model.MediaPackageV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteOriginEndpointRequest
extends MediaPackageV2Request
implements ToCopyableBuilder<Builder, DeleteOriginEndpointRequest> {
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelGroupName").getter(DeleteOriginEndpointRequest.getter(DeleteOriginEndpointRequest::channelGroupName)).setter(DeleteOriginEndpointRequest.setter(Builder::channelGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelGroupName").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(DeleteOriginEndpointRequest.getter(DeleteOriginEndpointRequest::channelName)).setter(DeleteOriginEndpointRequest.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelName").build()}).build();
    private static final SdkField<String> ORIGIN_ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginEndpointName").getter(DeleteOriginEndpointRequest.getter(DeleteOriginEndpointRequest::originEndpointName)).setter(DeleteOriginEndpointRequest.setter(Builder::originEndpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("OriginEndpointName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_GROUP_NAME_FIELD, CHANNEL_NAME_FIELD, ORIGIN_ENDPOINT_NAME_FIELD));
    private final String channelGroupName;
    private final String channelName;
    private final String originEndpointName;

    private DeleteOriginEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.originEndpointName = builder.originEndpointName;
    }

    public final String channelGroupName() {
        return this.channelGroupName;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String originEndpointName() {
        return this.originEndpointName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.originEndpointName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteOriginEndpointRequest)) {
            return false;
        }
        DeleteOriginEndpointRequest other = (DeleteOriginEndpointRequest)((Object)obj);
        return Objects.equals(this.channelGroupName(), other.channelGroupName()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.originEndpointName(), other.originEndpointName());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteOriginEndpointRequest").add("ChannelGroupName", (Object)this.channelGroupName()).add("ChannelName", (Object)this.channelName()).add("OriginEndpointName", (Object)this.originEndpointName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelGroupName": {
                return Optional.ofNullable(clazz.cast(this.channelGroupName()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "OriginEndpointName": {
                return Optional.ofNullable(clazz.cast(this.originEndpointName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteOriginEndpointRequest, T> g) {
        return obj -> g.apply((DeleteOriginEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageV2Request.BuilderImpl
    implements Builder {
        private String channelGroupName;
        private String channelName;
        private String originEndpointName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteOriginEndpointRequest model) {
            super(model);
            this.channelGroupName(model.channelGroupName);
            this.channelName(model.channelName);
            this.originEndpointName(model.originEndpointName);
        }

        public final String getChannelGroupName() {
            return this.channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getOriginEndpointName() {
            return this.originEndpointName;
        }

        public final void setOriginEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
        }

        @Override
        public final Builder originEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteOriginEndpointRequest build() {
            return new DeleteOriginEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaPackageV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteOriginEndpointRequest> {
        public Builder channelGroupName(String var1);

        public Builder channelName(String var1);

        public Builder originEndpointName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

