/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediapackagev2.model.ContainerType;
import software.amazon.awssdk.services.mediapackagev2.model.CreateDashManifestConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.CreateDashManifestsCopier;
import software.amazon.awssdk.services.mediapackagev2.model.CreateHlsManifestConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.CreateHlsManifestsCopier;
import software.amazon.awssdk.services.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.CreateLowLatencyHlsManifestsCopier;
import software.amazon.awssdk.services.mediapackagev2.model.ForceEndpointErrorConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.MediaPackageV2Request;
import software.amazon.awssdk.services.mediapackagev2.model.Segment;
import software.amazon.awssdk.services.mediapackagev2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOriginEndpointRequest
extends MediaPackageV2Request
implements ToCopyableBuilder<Builder, CreateOriginEndpointRequest> {
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelGroupName").getter(CreateOriginEndpointRequest.getter(CreateOriginEndpointRequest::channelGroupName)).setter(CreateOriginEndpointRequest.setter(Builder::channelGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelGroupName").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(CreateOriginEndpointRequest.getter(CreateOriginEndpointRequest::channelName)).setter(CreateOriginEndpointRequest.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelName").build()}).build();
    private static final SdkField<String> ORIGIN_ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginEndpointName").getter(CreateOriginEndpointRequest.getter(CreateOriginEndpointRequest::originEndpointName)).setter(CreateOriginEndpointRequest.setter(Builder::originEndpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginEndpointName").build()}).build();
    private static final SdkField<String> CONTAINER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerType").getter(CreateOriginEndpointRequest.getter(CreateOriginEndpointRequest::containerTypeAsString)).setter(CreateOriginEndpointRequest.setter(Builder::containerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerType").build()}).build();
    private static final SdkField<Segment> SEGMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Segment").getter(CreateOriginEndpointRequest.getter(CreateOriginEndpointRequest::segment)).setter(CreateOriginEndpointRequest.setter(Builder::segment)).constructor(Segment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segment").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateOriginEndpointRequest.getter(CreateOriginEndpointRequest::clientToken)).setter(CreateOriginEndpointRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-client-token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateOriginEndpointRequest.getter(CreateOriginEndpointRequest::description)).setter(CreateOriginEndpointRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> STARTOVER_WINDOW_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StartoverWindowSeconds").getter(CreateOriginEndpointRequest.getter(CreateOriginEndpointRequest::startoverWindowSeconds)).setter(CreateOriginEndpointRequest.setter(Builder::startoverWindowSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartoverWindowSeconds").build()}).build();
    private static final SdkField<List<CreateHlsManifestConfiguration>> HLS_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HlsManifests").getter(CreateOriginEndpointRequest.getter(CreateOriginEndpointRequest::hlsManifests)).setter(CreateOriginEndpointRequest.setter(Builder::hlsManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateHlsManifestConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CreateLowLatencyHlsManifestConfiguration>> LOW_LATENCY_HLS_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LowLatencyHlsManifests").getter(CreateOriginEndpointRequest.getter(CreateOriginEndpointRequest::lowLatencyHlsManifests)).setter(CreateOriginEndpointRequest.setter(Builder::lowLatencyHlsManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowLatencyHlsManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateLowLatencyHlsManifestConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CreateDashManifestConfiguration>> DASH_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DashManifests").getter(CreateOriginEndpointRequest.getter(CreateOriginEndpointRequest::dashManifests)).setter(CreateOriginEndpointRequest.setter(Builder::dashManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateDashManifestConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ForceEndpointErrorConfiguration> FORCE_ENDPOINT_ERROR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ForceEndpointErrorConfiguration").getter(CreateOriginEndpointRequest.getter(CreateOriginEndpointRequest::forceEndpointErrorConfiguration)).setter(CreateOriginEndpointRequest.setter(Builder::forceEndpointErrorConfiguration)).constructor(ForceEndpointErrorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceEndpointErrorConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateOriginEndpointRequest.getter(CreateOriginEndpointRequest::tags)).setter(CreateOriginEndpointRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_GROUP_NAME_FIELD, CHANNEL_NAME_FIELD, ORIGIN_ENDPOINT_NAME_FIELD, CONTAINER_TYPE_FIELD, SEGMENT_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, STARTOVER_WINDOW_SECONDS_FIELD, HLS_MANIFESTS_FIELD, LOW_LATENCY_HLS_MANIFESTS_FIELD, DASH_MANIFESTS_FIELD, FORCE_ENDPOINT_ERROR_CONFIGURATION_FIELD, TAGS_FIELD));
    private final String channelGroupName;
    private final String channelName;
    private final String originEndpointName;
    private final String containerType;
    private final Segment segment;
    private final String clientToken;
    private final String description;
    private final Integer startoverWindowSeconds;
    private final List<CreateHlsManifestConfiguration> hlsManifests;
    private final List<CreateLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests;
    private final List<CreateDashManifestConfiguration> dashManifests;
    private final ForceEndpointErrorConfiguration forceEndpointErrorConfiguration;
    private final Map<String, String> tags;

    private CreateOriginEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.originEndpointName = builder.originEndpointName;
        this.containerType = builder.containerType;
        this.segment = builder.segment;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.startoverWindowSeconds = builder.startoverWindowSeconds;
        this.hlsManifests = builder.hlsManifests;
        this.lowLatencyHlsManifests = builder.lowLatencyHlsManifests;
        this.dashManifests = builder.dashManifests;
        this.forceEndpointErrorConfiguration = builder.forceEndpointErrorConfiguration;
        this.tags = builder.tags;
    }

    public final String channelGroupName() {
        return this.channelGroupName;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String originEndpointName() {
        return this.originEndpointName;
    }

    public final ContainerType containerType() {
        return ContainerType.fromValue(this.containerType);
    }

    public final String containerTypeAsString() {
        return this.containerType;
    }

    public final Segment segment() {
        return this.segment;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final Integer startoverWindowSeconds() {
        return this.startoverWindowSeconds;
    }

    public final boolean hasHlsManifests() {
        return this.hlsManifests != null && !(this.hlsManifests instanceof SdkAutoConstructList);
    }

    public final List<CreateHlsManifestConfiguration> hlsManifests() {
        return this.hlsManifests;
    }

    public final boolean hasLowLatencyHlsManifests() {
        return this.lowLatencyHlsManifests != null && !(this.lowLatencyHlsManifests instanceof SdkAutoConstructList);
    }

    public final List<CreateLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests() {
        return this.lowLatencyHlsManifests;
    }

    public final boolean hasDashManifests() {
        return this.dashManifests != null && !(this.dashManifests instanceof SdkAutoConstructList);
    }

    public final List<CreateDashManifestConfiguration> dashManifests() {
        return this.dashManifests;
    }

    public final ForceEndpointErrorConfiguration forceEndpointErrorConfiguration() {
        return this.forceEndpointErrorConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.originEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segment());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.startoverWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHlsManifests() ? this.hlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLowLatencyHlsManifests() ? this.lowLatencyHlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDashManifests() ? this.dashManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.forceEndpointErrorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOriginEndpointRequest)) {
            return false;
        }
        CreateOriginEndpointRequest other = (CreateOriginEndpointRequest)((Object)obj);
        return Objects.equals(this.channelGroupName(), other.channelGroupName()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.originEndpointName(), other.originEndpointName()) && Objects.equals(this.containerTypeAsString(), other.containerTypeAsString()) && Objects.equals(this.segment(), other.segment()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.startoverWindowSeconds(), other.startoverWindowSeconds()) && this.hasHlsManifests() == other.hasHlsManifests() && Objects.equals(this.hlsManifests(), other.hlsManifests()) && this.hasLowLatencyHlsManifests() == other.hasLowLatencyHlsManifests() && Objects.equals(this.lowLatencyHlsManifests(), other.lowLatencyHlsManifests()) && this.hasDashManifests() == other.hasDashManifests() && Objects.equals(this.dashManifests(), other.dashManifests()) && Objects.equals(this.forceEndpointErrorConfiguration(), other.forceEndpointErrorConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOriginEndpointRequest").add("ChannelGroupName", (Object)this.channelGroupName()).add("ChannelName", (Object)this.channelName()).add("OriginEndpointName", (Object)this.originEndpointName()).add("ContainerType", (Object)this.containerTypeAsString()).add("Segment", (Object)this.segment()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("StartoverWindowSeconds", (Object)this.startoverWindowSeconds()).add("HlsManifests", this.hasHlsManifests() ? this.hlsManifests() : null).add("LowLatencyHlsManifests", this.hasLowLatencyHlsManifests() ? this.lowLatencyHlsManifests() : null).add("DashManifests", this.hasDashManifests() ? this.dashManifests() : null).add("ForceEndpointErrorConfiguration", (Object)this.forceEndpointErrorConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelGroupName": {
                return Optional.ofNullable(clazz.cast(this.channelGroupName()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "OriginEndpointName": {
                return Optional.ofNullable(clazz.cast(this.originEndpointName()));
            }
            case "ContainerType": {
                return Optional.ofNullable(clazz.cast(this.containerTypeAsString()));
            }
            case "Segment": {
                return Optional.ofNullable(clazz.cast(this.segment()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "StartoverWindowSeconds": {
                return Optional.ofNullable(clazz.cast(this.startoverWindowSeconds()));
            }
            case "HlsManifests": {
                return Optional.ofNullable(clazz.cast(this.hlsManifests()));
            }
            case "LowLatencyHlsManifests": {
                return Optional.ofNullable(clazz.cast(this.lowLatencyHlsManifests()));
            }
            case "DashManifests": {
                return Optional.ofNullable(clazz.cast(this.dashManifests()));
            }
            case "ForceEndpointErrorConfiguration": {
                return Optional.ofNullable(clazz.cast(this.forceEndpointErrorConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOriginEndpointRequest, T> g) {
        return obj -> g.apply((CreateOriginEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageV2Request.BuilderImpl
    implements Builder {
        private String channelGroupName;
        private String channelName;
        private String originEndpointName;
        private String containerType;
        private Segment segment;
        private String clientToken;
        private String description;
        private Integer startoverWindowSeconds;
        private List<CreateHlsManifestConfiguration> hlsManifests = DefaultSdkAutoConstructList.getInstance();
        private List<CreateLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests = DefaultSdkAutoConstructList.getInstance();
        private List<CreateDashManifestConfiguration> dashManifests = DefaultSdkAutoConstructList.getInstance();
        private ForceEndpointErrorConfiguration forceEndpointErrorConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOriginEndpointRequest model) {
            super(model);
            this.channelGroupName(model.channelGroupName);
            this.channelName(model.channelName);
            this.originEndpointName(model.originEndpointName);
            this.containerType(model.containerType);
            this.segment(model.segment);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.startoverWindowSeconds(model.startoverWindowSeconds);
            this.hlsManifests(model.hlsManifests);
            this.lowLatencyHlsManifests(model.lowLatencyHlsManifests);
            this.dashManifests(model.dashManifests);
            this.forceEndpointErrorConfiguration(model.forceEndpointErrorConfiguration);
            this.tags(model.tags);
        }

        public final String getChannelGroupName() {
            return this.channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getOriginEndpointName() {
            return this.originEndpointName;
        }

        public final void setOriginEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
        }

        @Override
        public final Builder originEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
            return this;
        }

        public final String getContainerType() {
            return this.containerType;
        }

        public final void setContainerType(String containerType) {
            this.containerType = containerType;
        }

        @Override
        public final Builder containerType(String containerType) {
            this.containerType = containerType;
            return this;
        }

        @Override
        public final Builder containerType(ContainerType containerType) {
            this.containerType(containerType == null ? null : containerType.toString());
            return this;
        }

        public final Segment.Builder getSegment() {
            return this.segment != null ? this.segment.toBuilder() : null;
        }

        public final void setSegment(Segment.BuilderImpl segment) {
            this.segment = segment != null ? segment.build() : null;
        }

        @Override
        public final Builder segment(Segment segment) {
            this.segment = segment;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getStartoverWindowSeconds() {
            return this.startoverWindowSeconds;
        }

        public final void setStartoverWindowSeconds(Integer startoverWindowSeconds) {
            this.startoverWindowSeconds = startoverWindowSeconds;
        }

        @Override
        public final Builder startoverWindowSeconds(Integer startoverWindowSeconds) {
            this.startoverWindowSeconds = startoverWindowSeconds;
            return this;
        }

        public final List<CreateHlsManifestConfiguration.Builder> getHlsManifests() {
            List<CreateHlsManifestConfiguration.Builder> result = CreateHlsManifestsCopier.copyToBuilder(this.hlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHlsManifests(Collection<CreateHlsManifestConfiguration.BuilderImpl> hlsManifests) {
            this.hlsManifests = CreateHlsManifestsCopier.copyFromBuilder(hlsManifests);
        }

        @Override
        public final Builder hlsManifests(Collection<CreateHlsManifestConfiguration> hlsManifests) {
            this.hlsManifests = CreateHlsManifestsCopier.copy(hlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(CreateHlsManifestConfiguration ... hlsManifests) {
            this.hlsManifests(Arrays.asList(hlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(Consumer<CreateHlsManifestConfiguration.Builder> ... hlsManifests) {
            this.hlsManifests(Stream.of(hlsManifests).map(c -> (CreateHlsManifestConfiguration)((CreateHlsManifestConfiguration.Builder)CreateHlsManifestConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CreateLowLatencyHlsManifestConfiguration.Builder> getLowLatencyHlsManifests() {
            List<CreateLowLatencyHlsManifestConfiguration.Builder> result = CreateLowLatencyHlsManifestsCopier.copyToBuilder(this.lowLatencyHlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLowLatencyHlsManifests(Collection<CreateLowLatencyHlsManifestConfiguration.BuilderImpl> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = CreateLowLatencyHlsManifestsCopier.copyFromBuilder(lowLatencyHlsManifests);
        }

        @Override
        public final Builder lowLatencyHlsManifests(Collection<CreateLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = CreateLowLatencyHlsManifestsCopier.copy(lowLatencyHlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(CreateLowLatencyHlsManifestConfiguration ... lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests(Arrays.asList(lowLatencyHlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(Consumer<CreateLowLatencyHlsManifestConfiguration.Builder> ... lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests(Stream.of(lowLatencyHlsManifests).map(c -> (CreateLowLatencyHlsManifestConfiguration)((CreateLowLatencyHlsManifestConfiguration.Builder)CreateLowLatencyHlsManifestConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CreateDashManifestConfiguration.Builder> getDashManifests() {
            List<CreateDashManifestConfiguration.Builder> result = CreateDashManifestsCopier.copyToBuilder(this.dashManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDashManifests(Collection<CreateDashManifestConfiguration.BuilderImpl> dashManifests) {
            this.dashManifests = CreateDashManifestsCopier.copyFromBuilder(dashManifests);
        }

        @Override
        public final Builder dashManifests(Collection<CreateDashManifestConfiguration> dashManifests) {
            this.dashManifests = CreateDashManifestsCopier.copy(dashManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(CreateDashManifestConfiguration ... dashManifests) {
            this.dashManifests(Arrays.asList(dashManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(Consumer<CreateDashManifestConfiguration.Builder> ... dashManifests) {
            this.dashManifests(Stream.of(dashManifests).map(c -> (CreateDashManifestConfiguration)((CreateDashManifestConfiguration.Builder)CreateDashManifestConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ForceEndpointErrorConfiguration.Builder getForceEndpointErrorConfiguration() {
            return this.forceEndpointErrorConfiguration != null ? this.forceEndpointErrorConfiguration.toBuilder() : null;
        }

        public final void setForceEndpointErrorConfiguration(ForceEndpointErrorConfiguration.BuilderImpl forceEndpointErrorConfiguration) {
            this.forceEndpointErrorConfiguration = forceEndpointErrorConfiguration != null ? forceEndpointErrorConfiguration.build() : null;
        }

        @Override
        public final Builder forceEndpointErrorConfiguration(ForceEndpointErrorConfiguration forceEndpointErrorConfiguration) {
            this.forceEndpointErrorConfiguration = forceEndpointErrorConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOriginEndpointRequest build() {
            return new CreateOriginEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaPackageV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOriginEndpointRequest> {
        public Builder channelGroupName(String var1);

        public Builder channelName(String var1);

        public Builder originEndpointName(String var1);

        public Builder containerType(String var1);

        public Builder containerType(ContainerType var1);

        public Builder segment(Segment var1);

        default public Builder segment(Consumer<Segment.Builder> segment) {
            return this.segment((Segment)((Segment.Builder)Segment.builder().applyMutation(segment)).build());
        }

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder startoverWindowSeconds(Integer var1);

        public Builder hlsManifests(Collection<CreateHlsManifestConfiguration> var1);

        public Builder hlsManifests(CreateHlsManifestConfiguration ... var1);

        public Builder hlsManifests(Consumer<CreateHlsManifestConfiguration.Builder> ... var1);

        public Builder lowLatencyHlsManifests(Collection<CreateLowLatencyHlsManifestConfiguration> var1);

        public Builder lowLatencyHlsManifests(CreateLowLatencyHlsManifestConfiguration ... var1);

        public Builder lowLatencyHlsManifests(Consumer<CreateLowLatencyHlsManifestConfiguration.Builder> ... var1);

        public Builder dashManifests(Collection<CreateDashManifestConfiguration> var1);

        public Builder dashManifests(CreateDashManifestConfiguration ... var1);

        public Builder dashManifests(Consumer<CreateDashManifestConfiguration.Builder> ... var1);

        public Builder forceEndpointErrorConfiguration(ForceEndpointErrorConfiguration var1);

        default public Builder forceEndpointErrorConfiguration(Consumer<ForceEndpointErrorConfiguration.Builder> forceEndpointErrorConfiguration) {
            return this.forceEndpointErrorConfiguration((ForceEndpointErrorConfiguration)((ForceEndpointErrorConfiguration.Builder)ForceEndpointErrorConfiguration.builder().applyMutation(forceEndpointErrorConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

