/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelListConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelListConfiguration> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ChannelListConfiguration.getter(ChannelListConfiguration::arn)).setter(ChannelListConfiguration.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(ChannelListConfiguration.getter(ChannelListConfiguration::channelName)).setter(ChannelListConfiguration.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelGroupName").getter(ChannelListConfiguration.getter(ChannelListConfiguration::channelGroupName)).setter(ChannelListConfiguration.setter(Builder::channelGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelGroupName").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(ChannelListConfiguration.getter(ChannelListConfiguration::createdAt)).setter(ChannelListConfiguration.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedAt").getter(ChannelListConfiguration.getter(ChannelListConfiguration::modifiedAt)).setter(ChannelListConfiguration.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ChannelListConfiguration.getter(ChannelListConfiguration::description)).setter(ChannelListConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNEL_NAME_FIELD, CHANNEL_GROUP_NAME_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String channelName;
    private final String channelGroupName;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final String description;

    private ChannelListConfiguration(BuilderImpl builder) {
        this.arn = builder.arn;
        this.channelName = builder.channelName;
        this.channelGroupName = builder.channelGroupName;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.description = builder.description;
    }

    public final String arn() {
        return this.arn;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String channelGroupName() {
        return this.channelGroupName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelListConfiguration)) {
            return false;
        }
        ChannelListConfiguration other = (ChannelListConfiguration)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.channelGroupName(), other.channelGroupName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"ChannelListConfiguration").add("Arn", (Object)this.arn()).add("ChannelName", (Object)this.channelName()).add("ChannelGroupName", (Object)this.channelGroupName()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "ChannelGroupName": {
                return Optional.ofNullable(clazz.cast(this.channelGroupName()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelListConfiguration, T> g) {
        return obj -> g.apply((ChannelListConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String channelName;
        private String channelGroupName;
        private Instant createdAt;
        private Instant modifiedAt;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelListConfiguration model) {
            this.arn(model.arn);
            this.channelName(model.channelName);
            this.channelGroupName(model.channelGroupName);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.description(model.description);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getChannelGroupName() {
            return this.channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public ChannelListConfiguration build() {
            return new ChannelListConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelListConfiguration> {
        public Builder arn(String var1);

        public Builder channelName(String var1);

        public Builder channelGroupName(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder description(String var1);
    }
}

