/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediapackagev2.MediaPackageV2AsyncClient;
import software.amazon.awssdk.services.mediapackagev2.model.ChannelGroupListConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsResponse;

public class ListChannelGroupsPublisher
implements SdkPublisher<ListChannelGroupsResponse> {
    private final MediaPackageV2AsyncClient client;
    private final ListChannelGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChannelGroupsPublisher(MediaPackageV2AsyncClient client, ListChannelGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChannelGroupsPublisher(MediaPackageV2AsyncClient client, ListChannelGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChannelGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChannelGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ChannelGroupListConfiguration> items() {
        Function<ListChannelGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListChannelGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListChannelGroupsResponseFetcher
    implements AsyncPageFetcher<ListChannelGroupsResponse> {
        private ListChannelGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChannelGroupsResponse> nextPage(ListChannelGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListChannelGroupsPublisher.this.client.listChannelGroups(ListChannelGroupsPublisher.this.firstRequest);
            }
            return ListChannelGroupsPublisher.this.client.listChannelGroups((ListChannelGroupsRequest)((Object)ListChannelGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

