/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.mediapackage.auth.scheme.MediaPackageAuthSchemeParams;
import software.amazon.awssdk.services.mediapackage.auth.scheme.internal.DefaultMediaPackageAuthSchemeProvider;
import software.amazon.awssdk.services.mediapackage.auth.scheme.internal.PreferredMediaPackageAuthSchemeProvider;

@SdkPublicApi
public interface MediaPackageAuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(MediaPackageAuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<MediaPackageAuthSchemeParams.Builder> consumer) {
        MediaPackageAuthSchemeParams.Builder builder = MediaPackageAuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static MediaPackageAuthSchemeProvider defaultProvider() {
        return DefaultMediaPackageAuthSchemeProvider.create();
    }

    public static MediaPackageAuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredMediaPackageAuthSchemeProvider(MediaPackageAuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

