/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackage.model.MediaPackageResponse;
import software.amazon.awssdk.services.mediapackage.model.S3Destination;
import software.amazon.awssdk.services.mediapackage.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHarvestJobResponse
extends MediaPackageResponse
implements ToCopyableBuilder<Builder, CreateHarvestJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateHarvestJobResponse.getter(CreateHarvestJobResponse::arn)).setter(CreateHarvestJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(CreateHarvestJobResponse.getter(CreateHarvestJobResponse::channelId)).setter(CreateHarvestJobResponse.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()}).build();
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedAt").getter(CreateHarvestJobResponse.getter(CreateHarvestJobResponse::createdAt)).setter(CreateHarvestJobResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndTime").getter(CreateHarvestJobResponse.getter(CreateHarvestJobResponse::endTime)).setter(CreateHarvestJobResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CreateHarvestJobResponse.getter(CreateHarvestJobResponse::id)).setter(CreateHarvestJobResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ORIGIN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginEndpointId").getter(CreateHarvestJobResponse.getter(CreateHarvestJobResponse::originEndpointId)).setter(CreateHarvestJobResponse.setter(Builder::originEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originEndpointId").build()}).build();
    private static final SdkField<S3Destination> S3_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Destination").getter(CreateHarvestJobResponse.getter(CreateHarvestJobResponse::s3Destination)).setter(CreateHarvestJobResponse.setter(Builder::s3Destination)).constructor(S3Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()}).build();
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartTime").getter(CreateHarvestJobResponse.getter(CreateHarvestJobResponse::startTime)).setter(CreateHarvestJobResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateHarvestJobResponse.getter(CreateHarvestJobResponse::statusAsString)).setter(CreateHarvestJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNEL_ID_FIELD, CREATED_AT_FIELD, END_TIME_FIELD, ID_FIELD, ORIGIN_ENDPOINT_ID_FIELD, S3_DESTINATION_FIELD, START_TIME_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateHarvestJobResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String channelId;
    private final String createdAt;
    private final String endTime;
    private final String id;
    private final String originEndpointId;
    private final S3Destination s3Destination;
    private final String startTime;
    private final String status;

    private CreateHarvestJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.channelId = builder.channelId;
        this.createdAt = builder.createdAt;
        this.endTime = builder.endTime;
        this.id = builder.id;
        this.originEndpointId = builder.originEndpointId;
        this.s3Destination = builder.s3Destination;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String channelId() {
        return this.channelId;
    }

    public final String createdAt() {
        return this.createdAt;
    }

    public final String endTime() {
        return this.endTime;
    }

    public final String id() {
        return this.id;
    }

    public final String originEndpointId() {
        return this.originEndpointId;
    }

    public final S3Destination s3Destination() {
        return this.s3Destination;
    }

    public final String startTime() {
        return this.startTime;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.originEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHarvestJobResponse)) {
            return false;
        }
        CreateHarvestJobResponse other = (CreateHarvestJobResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.originEndpointId(), other.originEndpointId()) && Objects.equals(this.s3Destination(), other.s3Destination()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateHarvestJobResponse").add("Arn", (Object)this.arn()).add("ChannelId", (Object)this.channelId()).add("CreatedAt", (Object)this.createdAt()).add("EndTime", (Object)this.endTime()).add("Id", (Object)this.id()).add("OriginEndpointId", (Object)this.originEndpointId()).add("S3Destination", (Object)this.s3Destination()).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "OriginEndpointId": {
                return Optional.ofNullable(clazz.cast(this.originEndpointId()));
            }
            case "S3Destination": {
                return Optional.ofNullable(clazz.cast(this.s3Destination()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("channelId", CHANNEL_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("id", ID_FIELD);
        map.put("originEndpointId", ORIGIN_ENDPOINT_ID_FIELD);
        map.put("s3Destination", S3_DESTINATION_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateHarvestJobResponse, T> g) {
        return obj -> g.apply((CreateHarvestJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String channelId;
        private String createdAt;
        private String endTime;
        private String id;
        private String originEndpointId;
        private S3Destination s3Destination;
        private String startTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHarvestJobResponse model) {
            super(model);
            this.arn(model.arn);
            this.channelId(model.channelId);
            this.createdAt(model.createdAt);
            this.endTime(model.endTime);
            this.id(model.id);
            this.originEndpointId(model.originEndpointId);
            this.s3Destination(model.s3Destination);
            this.startTime(model.startTime);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getOriginEndpointId() {
            return this.originEndpointId;
        }

        public final void setOriginEndpointId(String originEndpointId) {
            this.originEndpointId = originEndpointId;
        }

        @Override
        public final Builder originEndpointId(String originEndpointId) {
            this.originEndpointId = originEndpointId;
            return this;
        }

        public final S3Destination.Builder getS3Destination() {
            return this.s3Destination != null ? this.s3Destination.toBuilder() : null;
        }

        public final void setS3Destination(S3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public final Builder s3Destination(S3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public final String getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateHarvestJobResponse build() {
            return new CreateHarvestJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaPackageResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHarvestJobResponse> {
        public Builder arn(String var1);

        public Builder channelId(String var1);

        public Builder createdAt(String var1);

        public Builder endTime(String var1);

        public Builder id(String var1);

        public Builder originEndpointId(String var1);

        public Builder s3Destination(S3Destination var1);

        default public Builder s3Destination(Consumer<S3Destination.Builder> s3Destination) {
            return this.s3Destination((S3Destination)((S3Destination.Builder)S3Destination.builder().applyMutation(s3Destination)).build());
        }

        public Builder startTime(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);
    }
}

