/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackage.model.MediaPackageRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RotateIngestEndpointCredentialsRequest
extends MediaPackageRequest
implements ToCopyableBuilder<Builder, RotateIngestEndpointCredentialsRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(RotateIngestEndpointCredentialsRequest.getter(RotateIngestEndpointCredentialsRequest::id)).setter(RotateIngestEndpointCredentialsRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> INGEST_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngestEndpointId").getter(RotateIngestEndpointCredentialsRequest.getter(RotateIngestEndpointCredentialsRequest::ingestEndpointId)).setter(RotateIngestEndpointCredentialsRequest.setter(Builder::ingestEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ingest_endpoint_id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, INGEST_ENDPOINT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RotateIngestEndpointCredentialsRequest.memberNameToFieldInitializer();
    private final String id;
    private final String ingestEndpointId;

    private RotateIngestEndpointCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.ingestEndpointId = builder.ingestEndpointId;
    }

    public final String id() {
        return this.id;
    }

    public final String ingestEndpointId() {
        return this.ingestEndpointId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestEndpointId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotateIngestEndpointCredentialsRequest)) {
            return false;
        }
        RotateIngestEndpointCredentialsRequest other = (RotateIngestEndpointCredentialsRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.ingestEndpointId(), other.ingestEndpointId());
    }

    public final String toString() {
        return ToString.builder((String)"RotateIngestEndpointCredentialsRequest").add("Id", (Object)this.id()).add("IngestEndpointId", (Object)this.ingestEndpointId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IngestEndpointId": {
                return Optional.ofNullable(clazz.cast(this.ingestEndpointId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("id", ID_FIELD);
        map.put("ingest_endpoint_id", INGEST_ENDPOINT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RotateIngestEndpointCredentialsRequest, T> g) {
        return obj -> g.apply((RotateIngestEndpointCredentialsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageRequest.BuilderImpl
    implements Builder {
        private String id;
        private String ingestEndpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(RotateIngestEndpointCredentialsRequest model) {
            super(model);
            this.id(model.id);
            this.ingestEndpointId(model.ingestEndpointId);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIngestEndpointId() {
            return this.ingestEndpointId;
        }

        public final void setIngestEndpointId(String ingestEndpointId) {
            this.ingestEndpointId = ingestEndpointId;
        }

        @Override
        public final Builder ingestEndpointId(String ingestEndpointId) {
            this.ingestEndpointId = ingestEndpointId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RotateIngestEndpointCredentialsRequest build() {
            return new RotateIngestEndpointCredentialsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaPackageRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RotateIngestEndpointCredentialsRequest> {
        public Builder id(String var1);

        public Builder ingestEndpointId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

