/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackage.model.EgressAccessLogs;
import software.amazon.awssdk.services.mediapackage.model.IngressAccessLogs;
import software.amazon.awssdk.services.mediapackage.model.MediaPackageRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigureLogsRequest
extends MediaPackageRequest
implements ToCopyableBuilder<Builder, ConfigureLogsRequest> {
    private static final SdkField<EgressAccessLogs> EGRESS_ACCESS_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EgressAccessLogs").getter(ConfigureLogsRequest.getter(ConfigureLogsRequest::egressAccessLogs)).setter(ConfigureLogsRequest.setter(Builder::egressAccessLogs)).constructor(EgressAccessLogs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressAccessLogs").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ConfigureLogsRequest.getter(ConfigureLogsRequest::id)).setter(ConfigureLogsRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<IngressAccessLogs> INGRESS_ACCESS_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngressAccessLogs").getter(ConfigureLogsRequest.getter(ConfigureLogsRequest::ingressAccessLogs)).setter(ConfigureLogsRequest.setter(Builder::ingressAccessLogs)).constructor(IngressAccessLogs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressAccessLogs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EGRESS_ACCESS_LOGS_FIELD, ID_FIELD, INGRESS_ACCESS_LOGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("egressAccessLogs", EGRESS_ACCESS_LOGS_FIELD);
            this.put("id", ID_FIELD);
            this.put("ingressAccessLogs", INGRESS_ACCESS_LOGS_FIELD);
        }
    });
    private final EgressAccessLogs egressAccessLogs;
    private final String id;
    private final IngressAccessLogs ingressAccessLogs;

    private ConfigureLogsRequest(BuilderImpl builder) {
        super(builder);
        this.egressAccessLogs = builder.egressAccessLogs;
        this.id = builder.id;
        this.ingressAccessLogs = builder.ingressAccessLogs;
    }

    public final EgressAccessLogs egressAccessLogs() {
        return this.egressAccessLogs;
    }

    public final String id() {
        return this.id;
    }

    public final IngressAccessLogs ingressAccessLogs() {
        return this.ingressAccessLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.egressAccessLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressAccessLogs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureLogsRequest)) {
            return false;
        }
        ConfigureLogsRequest other = (ConfigureLogsRequest)((Object)obj);
        return Objects.equals(this.egressAccessLogs(), other.egressAccessLogs()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.ingressAccessLogs(), other.ingressAccessLogs());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigureLogsRequest").add("EgressAccessLogs", (Object)this.egressAccessLogs()).add("Id", (Object)this.id()).add("IngressAccessLogs", (Object)this.ingressAccessLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EgressAccessLogs": {
                return Optional.ofNullable(clazz.cast(this.egressAccessLogs()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IngressAccessLogs": {
                return Optional.ofNullable(clazz.cast(this.ingressAccessLogs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConfigureLogsRequest, T> g) {
        return obj -> g.apply((ConfigureLogsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageRequest.BuilderImpl
    implements Builder {
        private EgressAccessLogs egressAccessLogs;
        private String id;
        private IngressAccessLogs ingressAccessLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureLogsRequest model) {
            super(model);
            this.egressAccessLogs(model.egressAccessLogs);
            this.id(model.id);
            this.ingressAccessLogs(model.ingressAccessLogs);
        }

        public final EgressAccessLogs.Builder getEgressAccessLogs() {
            return this.egressAccessLogs != null ? this.egressAccessLogs.toBuilder() : null;
        }

        public final void setEgressAccessLogs(EgressAccessLogs.BuilderImpl egressAccessLogs) {
            this.egressAccessLogs = egressAccessLogs != null ? egressAccessLogs.build() : null;
        }

        @Override
        public final Builder egressAccessLogs(EgressAccessLogs egressAccessLogs) {
            this.egressAccessLogs = egressAccessLogs;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final IngressAccessLogs.Builder getIngressAccessLogs() {
            return this.ingressAccessLogs != null ? this.ingressAccessLogs.toBuilder() : null;
        }

        public final void setIngressAccessLogs(IngressAccessLogs.BuilderImpl ingressAccessLogs) {
            this.ingressAccessLogs = ingressAccessLogs != null ? ingressAccessLogs.build() : null;
        }

        @Override
        public final Builder ingressAccessLogs(IngressAccessLogs ingressAccessLogs) {
            this.ingressAccessLogs = ingressAccessLogs;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfigureLogsRequest build() {
            return new ConfigureLogsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaPackageRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConfigureLogsRequest> {
        public Builder egressAccessLogs(EgressAccessLogs var1);

        default public Builder egressAccessLogs(Consumer<EgressAccessLogs.Builder> egressAccessLogs) {
            return this.egressAccessLogs((EgressAccessLogs)((EgressAccessLogs.Builder)EgressAccessLogs.builder().applyMutation(egressAccessLogs)).build());
        }

        public Builder id(String var1);

        public Builder ingressAccessLogs(IngressAccessLogs var1);

        default public Builder ingressAccessLogs(Consumer<IngressAccessLogs.Builder> ingressAccessLogs) {
            return this.ingressAccessLogs((IngressAccessLogs)((IngressAccessLogs.Builder)IngressAccessLogs.builder().applyMutation(ingressAccessLogs)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

