/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackage.model.CmafEncryptionMethod;
import software.amazon.awssdk.services.mediapackage.model.SpekeKeyProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CmafEncryption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CmafEncryption> {
    private static final SdkField<String> CONSTANT_INITIALIZATION_VECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConstantInitializationVector").getter(CmafEncryption.getter(CmafEncryption::constantInitializationVector)).setter(CmafEncryption.setter(Builder::constantInitializationVector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("constantInitializationVector").build()}).build();
    private static final SdkField<String> ENCRYPTION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionMethod").getter(CmafEncryption.getter(CmafEncryption::encryptionMethodAsString)).setter(CmafEncryption.setter(Builder::encryptionMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionMethod").build()}).build();
    private static final SdkField<Integer> KEY_ROTATION_INTERVAL_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("KeyRotationIntervalSeconds").getter(CmafEncryption.getter(CmafEncryption::keyRotationIntervalSeconds)).setter(CmafEncryption.setter(Builder::keyRotationIntervalSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyRotationIntervalSeconds").build()}).build();
    private static final SdkField<SpekeKeyProvider> SPEKE_KEY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpekeKeyProvider").getter(CmafEncryption.getter(CmafEncryption::spekeKeyProvider)).setter(CmafEncryption.setter(Builder::spekeKeyProvider)).constructor(SpekeKeyProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spekeKeyProvider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTANT_INITIALIZATION_VECTOR_FIELD, ENCRYPTION_METHOD_FIELD, KEY_ROTATION_INTERVAL_SECONDS_FIELD, SPEKE_KEY_PROVIDER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String constantInitializationVector;
    private final String encryptionMethod;
    private final Integer keyRotationIntervalSeconds;
    private final SpekeKeyProvider spekeKeyProvider;

    private CmafEncryption(BuilderImpl builder) {
        this.constantInitializationVector = builder.constantInitializationVector;
        this.encryptionMethod = builder.encryptionMethod;
        this.keyRotationIntervalSeconds = builder.keyRotationIntervalSeconds;
        this.spekeKeyProvider = builder.spekeKeyProvider;
    }

    public final String constantInitializationVector() {
        return this.constantInitializationVector;
    }

    public final CmafEncryptionMethod encryptionMethod() {
        return CmafEncryptionMethod.fromValue(this.encryptionMethod);
    }

    public final String encryptionMethodAsString() {
        return this.encryptionMethod;
    }

    public final Integer keyRotationIntervalSeconds() {
        return this.keyRotationIntervalSeconds;
    }

    public final SpekeKeyProvider spekeKeyProvider() {
        return this.spekeKeyProvider;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.constantInitializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyRotationIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.spekeKeyProvider());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafEncryption)) {
            return false;
        }
        CmafEncryption other = (CmafEncryption)obj;
        return Objects.equals(this.constantInitializationVector(), other.constantInitializationVector()) && Objects.equals(this.encryptionMethodAsString(), other.encryptionMethodAsString()) && Objects.equals(this.keyRotationIntervalSeconds(), other.keyRotationIntervalSeconds()) && Objects.equals(this.spekeKeyProvider(), other.spekeKeyProvider());
    }

    public final String toString() {
        return ToString.builder((String)"CmafEncryption").add("ConstantInitializationVector", (Object)this.constantInitializationVector()).add("EncryptionMethod", (Object)this.encryptionMethodAsString()).add("KeyRotationIntervalSeconds", (Object)this.keyRotationIntervalSeconds()).add("SpekeKeyProvider", (Object)this.spekeKeyProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConstantInitializationVector": {
                return Optional.ofNullable(clazz.cast(this.constantInitializationVector()));
            }
            case "EncryptionMethod": {
                return Optional.ofNullable(clazz.cast(this.encryptionMethodAsString()));
            }
            case "KeyRotationIntervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.keyRotationIntervalSeconds()));
            }
            case "SpekeKeyProvider": {
                return Optional.ofNullable(clazz.cast(this.spekeKeyProvider()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CmafEncryption, T> g) {
        return obj -> g.apply((CmafEncryption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String constantInitializationVector;
        private String encryptionMethod;
        private Integer keyRotationIntervalSeconds;
        private SpekeKeyProvider spekeKeyProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(CmafEncryption model) {
            this.constantInitializationVector(model.constantInitializationVector);
            this.encryptionMethod(model.encryptionMethod);
            this.keyRotationIntervalSeconds(model.keyRotationIntervalSeconds);
            this.spekeKeyProvider(model.spekeKeyProvider);
        }

        public final String getConstantInitializationVector() {
            return this.constantInitializationVector;
        }

        public final void setConstantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
        }

        @Override
        public final Builder constantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
            return this;
        }

        public final String getEncryptionMethod() {
            return this.encryptionMethod;
        }

        public final void setEncryptionMethod(String encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
        }

        @Override
        public final Builder encryptionMethod(String encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
            return this;
        }

        @Override
        public final Builder encryptionMethod(CmafEncryptionMethod encryptionMethod) {
            this.encryptionMethod(encryptionMethod == null ? null : encryptionMethod.toString());
            return this;
        }

        public final Integer getKeyRotationIntervalSeconds() {
            return this.keyRotationIntervalSeconds;
        }

        public final void setKeyRotationIntervalSeconds(Integer keyRotationIntervalSeconds) {
            this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
        }

        @Override
        public final Builder keyRotationIntervalSeconds(Integer keyRotationIntervalSeconds) {
            this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
            return this;
        }

        public final SpekeKeyProvider.Builder getSpekeKeyProvider() {
            return this.spekeKeyProvider != null ? this.spekeKeyProvider.toBuilder() : null;
        }

        public final void setSpekeKeyProvider(SpekeKeyProvider.BuilderImpl spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider != null ? spekeKeyProvider.build() : null;
        }

        @Override
        public final Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider;
            return this;
        }

        public CmafEncryption build() {
            return new CmafEncryption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CmafEncryption> {
        public Builder constantInitializationVector(String var1);

        public Builder encryptionMethod(String var1);

        public Builder encryptionMethod(CmafEncryptionMethod var1);

        public Builder keyRotationIntervalSeconds(Integer var1);

        public Builder spekeKeyProvider(SpekeKeyProvider var1);

        default public Builder spekeKeyProvider(Consumer<SpekeKeyProvider.Builder> spekeKeyProvider) {
            return this.spekeKeyProvider((SpekeKeyProvider)((SpekeKeyProvider.Builder)SpekeKeyProvider.builder().applyMutation(spekeKeyProvider)).build());
        }
    }
}

