/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediapackage.model.EgressAccessLogs;
import software.amazon.awssdk.services.mediapackage.model.HlsIngest;
import software.amazon.awssdk.services.mediapackage.model.IngressAccessLogs;
import software.amazon.awssdk.services.mediapackage.model.MediaPackageResponse;
import software.amazon.awssdk.services.mediapackage.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RotateIngestEndpointCredentialsResponse
extends MediaPackageResponse
implements ToCopyableBuilder<Builder, RotateIngestEndpointCredentialsResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(RotateIngestEndpointCredentialsResponse.getter(RotateIngestEndpointCredentialsResponse::arn)).setter(RotateIngestEndpointCredentialsResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RotateIngestEndpointCredentialsResponse.getter(RotateIngestEndpointCredentialsResponse::description)).setter(RotateIngestEndpointCredentialsResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<EgressAccessLogs> EGRESS_ACCESS_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EgressAccessLogs").getter(RotateIngestEndpointCredentialsResponse.getter(RotateIngestEndpointCredentialsResponse::egressAccessLogs)).setter(RotateIngestEndpointCredentialsResponse.setter(Builder::egressAccessLogs)).constructor(EgressAccessLogs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressAccessLogs").build()}).build();
    private static final SdkField<HlsIngest> HLS_INGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsIngest").getter(RotateIngestEndpointCredentialsResponse.getter(RotateIngestEndpointCredentialsResponse::hlsIngest)).setter(RotateIngestEndpointCredentialsResponse.setter(Builder::hlsIngest)).constructor(HlsIngest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsIngest").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(RotateIngestEndpointCredentialsResponse.getter(RotateIngestEndpointCredentialsResponse::id)).setter(RotateIngestEndpointCredentialsResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<IngressAccessLogs> INGRESS_ACCESS_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngressAccessLogs").getter(RotateIngestEndpointCredentialsResponse.getter(RotateIngestEndpointCredentialsResponse::ingressAccessLogs)).setter(RotateIngestEndpointCredentialsResponse.setter(Builder::ingressAccessLogs)).constructor(IngressAccessLogs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressAccessLogs").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(RotateIngestEndpointCredentialsResponse.getter(RotateIngestEndpointCredentialsResponse::tags)).setter(RotateIngestEndpointCredentialsResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD, EGRESS_ACCESS_LOGS_FIELD, HLS_INGEST_FIELD, ID_FIELD, INGRESS_ACCESS_LOGS_FIELD, TAGS_FIELD));
    private final String arn;
    private final String description;
    private final EgressAccessLogs egressAccessLogs;
    private final HlsIngest hlsIngest;
    private final String id;
    private final IngressAccessLogs ingressAccessLogs;
    private final Map<String, String> tags;

    private RotateIngestEndpointCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.description = builder.description;
        this.egressAccessLogs = builder.egressAccessLogs;
        this.hlsIngest = builder.hlsIngest;
        this.id = builder.id;
        this.ingressAccessLogs = builder.ingressAccessLogs;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final EgressAccessLogs egressAccessLogs() {
        return this.egressAccessLogs;
    }

    public final HlsIngest hlsIngest() {
        return this.hlsIngest;
    }

    public final String id() {
        return this.id;
    }

    public final IngressAccessLogs ingressAccessLogs() {
        return this.ingressAccessLogs;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressAccessLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsIngest());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressAccessLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotateIngestEndpointCredentialsResponse)) {
            return false;
        }
        RotateIngestEndpointCredentialsResponse other = (RotateIngestEndpointCredentialsResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.egressAccessLogs(), other.egressAccessLogs()) && Objects.equals(this.hlsIngest(), other.hlsIngest()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.ingressAccessLogs(), other.ingressAccessLogs()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"RotateIngestEndpointCredentialsResponse").add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("EgressAccessLogs", (Object)this.egressAccessLogs()).add("HlsIngest", (Object)this.hlsIngest()).add("Id", (Object)this.id()).add("IngressAccessLogs", (Object)this.ingressAccessLogs()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EgressAccessLogs": {
                return Optional.ofNullable(clazz.cast(this.egressAccessLogs()));
            }
            case "HlsIngest": {
                return Optional.ofNullable(clazz.cast(this.hlsIngest()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IngressAccessLogs": {
                return Optional.ofNullable(clazz.cast(this.ingressAccessLogs()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RotateIngestEndpointCredentialsResponse, T> g) {
        return obj -> g.apply((RotateIngestEndpointCredentialsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String description;
        private EgressAccessLogs egressAccessLogs;
        private HlsIngest hlsIngest;
        private String id;
        private IngressAccessLogs ingressAccessLogs;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RotateIngestEndpointCredentialsResponse model) {
            super(model);
            this.arn(model.arn);
            this.description(model.description);
            this.egressAccessLogs(model.egressAccessLogs);
            this.hlsIngest(model.hlsIngest);
            this.id(model.id);
            this.ingressAccessLogs(model.ingressAccessLogs);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final EgressAccessLogs.Builder getEgressAccessLogs() {
            return this.egressAccessLogs != null ? this.egressAccessLogs.toBuilder() : null;
        }

        @Override
        public final Builder egressAccessLogs(EgressAccessLogs egressAccessLogs) {
            this.egressAccessLogs = egressAccessLogs;
            return this;
        }

        public final void setEgressAccessLogs(EgressAccessLogs.BuilderImpl egressAccessLogs) {
            this.egressAccessLogs = egressAccessLogs != null ? egressAccessLogs.build() : null;
        }

        public final HlsIngest.Builder getHlsIngest() {
            return this.hlsIngest != null ? this.hlsIngest.toBuilder() : null;
        }

        @Override
        public final Builder hlsIngest(HlsIngest hlsIngest) {
            this.hlsIngest = hlsIngest;
            return this;
        }

        public final void setHlsIngest(HlsIngest.BuilderImpl hlsIngest) {
            this.hlsIngest = hlsIngest != null ? hlsIngest.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final IngressAccessLogs.Builder getIngressAccessLogs() {
            return this.ingressAccessLogs != null ? this.ingressAccessLogs.toBuilder() : null;
        }

        @Override
        public final Builder ingressAccessLogs(IngressAccessLogs ingressAccessLogs) {
            this.ingressAccessLogs = ingressAccessLogs;
            return this;
        }

        public final void setIngressAccessLogs(IngressAccessLogs.BuilderImpl ingressAccessLogs) {
            this.ingressAccessLogs = ingressAccessLogs != null ? ingressAccessLogs.build() : null;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public RotateIngestEndpointCredentialsResponse build() {
            return new RotateIngestEndpointCredentialsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaPackageResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RotateIngestEndpointCredentialsResponse> {
        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder egressAccessLogs(EgressAccessLogs var1);

        default public Builder egressAccessLogs(Consumer<EgressAccessLogs.Builder> egressAccessLogs) {
            return this.egressAccessLogs((EgressAccessLogs)((EgressAccessLogs.Builder)EgressAccessLogs.builder().applyMutation(egressAccessLogs)).build());
        }

        public Builder hlsIngest(HlsIngest var1);

        default public Builder hlsIngest(Consumer<HlsIngest.Builder> hlsIngest) {
            return this.hlsIngest((HlsIngest)((HlsIngest.Builder)HlsIngest.builder().applyMutation(hlsIngest)).build());
        }

        public Builder id(String var1);

        public Builder ingressAccessLogs(IngressAccessLogs var1);

        default public Builder ingressAccessLogs(Consumer<IngressAccessLogs.Builder> ingressAccessLogs) {
            return this.ingressAccessLogs((IngressAccessLogs)((IngressAccessLogs.Builder)IngressAccessLogs.builder().applyMutation(ingressAccessLogs)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

