/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackage.model.IngestEndpoint;
import software.amazon.awssdk.services.mediapackage.model.___listOfIngestEndpointCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsIngest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsIngest> {
    private static final SdkField<List<IngestEndpoint>> INGEST_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(HlsIngest.getter(HlsIngest::ingestEndpoints)).setter(HlsIngest.setter(Builder::ingestEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IngestEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGEST_ENDPOINTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<IngestEndpoint> ingestEndpoints;

    private HlsIngest(BuilderImpl builder) {
        this.ingestEndpoints = builder.ingestEndpoints;
    }

    public boolean hasIngestEndpoints() {
        return this.ingestEndpoints != null && !(this.ingestEndpoints instanceof SdkAutoConstructList);
    }

    public List<IngestEndpoint> ingestEndpoints() {
        return this.ingestEndpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestEndpoints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsIngest)) {
            return false;
        }
        HlsIngest other = (HlsIngest)obj;
        return Objects.equals(this.ingestEndpoints(), other.ingestEndpoints());
    }

    public String toString() {
        return ToString.builder((String)"HlsIngest").add("IngestEndpoints", this.ingestEndpoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IngestEndpoints": {
                return Optional.ofNullable(clazz.cast(this.ingestEndpoints()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsIngest, T> g) {
        return obj -> g.apply((HlsIngest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<IngestEndpoint> ingestEndpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HlsIngest model) {
            this.ingestEndpoints(model.ingestEndpoints);
        }

        public final Collection<IngestEndpoint.Builder> getIngestEndpoints() {
            return this.ingestEndpoints != null ? (Collection)this.ingestEndpoints.stream().map(IngestEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ingestEndpoints(Collection<IngestEndpoint> ingestEndpoints) {
            this.ingestEndpoints = ___listOfIngestEndpointCopier.copy(ingestEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestEndpoints(IngestEndpoint ... ingestEndpoints) {
            this.ingestEndpoints(Arrays.asList(ingestEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestEndpoints(Consumer<IngestEndpoint.Builder> ... ingestEndpoints) {
            this.ingestEndpoints(Stream.of(ingestEndpoints).map(c -> (IngestEndpoint)((IngestEndpoint.Builder)IngestEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIngestEndpoints(Collection<IngestEndpoint.BuilderImpl> ingestEndpoints) {
            this.ingestEndpoints = ___listOfIngestEndpointCopier.copyFromBuilder(ingestEndpoints);
        }

        public HlsIngest build() {
            return new HlsIngest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsIngest> {
        public Builder ingestEndpoints(Collection<IngestEndpoint> var1);

        public Builder ingestEndpoints(IngestEndpoint ... var1);

        public Builder ingestEndpoints(Consumer<IngestEndpoint.Builder> ... var1);
    }
}

