/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An HTTP Live Streaming (HLS) encryption configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsEncryption implements SdkPojo, Serializable, ToCopyableBuilder<HlsEncryption.Builder, HlsEncryption> {
    private static final SdkField<String> CONSTANT_INITIALIZATION_VECTOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HlsEncryption::constantInitializationVector))
            .setter(setter(Builder::constantInitializationVector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("constantInitializationVector")
                    .build()).build();

    private static final SdkField<String> ENCRYPTION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsEncryption::encryptionMethodAsString)).setter(setter(Builder::encryptionMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionMethod").build()).build();

    private static final SdkField<Integer> KEY_ROTATION_INTERVAL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsEncryption::keyRotationIntervalSeconds))
            .setter(setter(Builder::keyRotationIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyRotationIntervalSeconds").build())
            .build();

    private static final SdkField<Boolean> REPEAT_EXT_X_KEY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(HlsEncryption::repeatExtXKey)).setter(setter(Builder::repeatExtXKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repeatExtXKey").build()).build();

    private static final SdkField<SpekeKeyProvider> SPEKE_KEY_PROVIDER_FIELD = SdkField
            .<SpekeKeyProvider> builder(MarshallingType.SDK_POJO).getter(getter(HlsEncryption::spekeKeyProvider))
            .setter(setter(Builder::spekeKeyProvider)).constructor(SpekeKeyProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spekeKeyProvider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONSTANT_INITIALIZATION_VECTOR_FIELD, ENCRYPTION_METHOD_FIELD, KEY_ROTATION_INTERVAL_SECONDS_FIELD,
            REPEAT_EXT_X_KEY_FIELD, SPEKE_KEY_PROVIDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String constantInitializationVector;

    private final String encryptionMethod;

    private final Integer keyRotationIntervalSeconds;

    private final Boolean repeatExtXKey;

    private final SpekeKeyProvider spekeKeyProvider;

    private HlsEncryption(BuilderImpl builder) {
        this.constantInitializationVector = builder.constantInitializationVector;
        this.encryptionMethod = builder.encryptionMethod;
        this.keyRotationIntervalSeconds = builder.keyRotationIntervalSeconds;
        this.repeatExtXKey = builder.repeatExtXKey;
        this.spekeKeyProvider = builder.spekeKeyProvider;
    }

    /**
     * A constant initialization vector for encryption (optional). When not specified the initialization vector will be
     * periodically rotated.
     *
     * @return A constant initialization vector for encryption (optional). When not specified the initialization vector
     *         will be periodically rotated.
     */
    public String constantInitializationVector() {
        return constantInitializationVector;
    }

    /**
     * The encryption method to use.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMethod}
     * will return {@link EncryptionMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionMethodAsString}.
     * </p>
     * 
     * @return The encryption method to use.
     * @see EncryptionMethod
     */
    public EncryptionMethod encryptionMethod() {
        return EncryptionMethod.fromValue(encryptionMethod);
    }

    /**
     * The encryption method to use.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMethod}
     * will return {@link EncryptionMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionMethodAsString}.
     * </p>
     * 
     * @return The encryption method to use.
     * @see EncryptionMethod
     */
    public String encryptionMethodAsString() {
        return encryptionMethod;
    }

    /**
     * Interval (in seconds) between each encryption key rotation.
     * 
     * @return Interval (in seconds) between each encryption key rotation.
     */
    public Integer keyRotationIntervalSeconds() {
        return keyRotationIntervalSeconds;
    }

    /**
     * When enabled, the EXT-X-KEY tag will be repeated in output manifests.
     * 
     * @return When enabled, the EXT-X-KEY tag will be repeated in output manifests.
     */
    public Boolean repeatExtXKey() {
        return repeatExtXKey;
    }

    /**
     * Returns the value of the SpekeKeyProvider property for this object.
     * 
     * @return The value of the SpekeKeyProvider property for this object.
     */
    public SpekeKeyProvider spekeKeyProvider() {
        return spekeKeyProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(constantInitializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyRotationIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(repeatExtXKey());
        hashCode = 31 * hashCode + Objects.hashCode(spekeKeyProvider());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsEncryption)) {
            return false;
        }
        HlsEncryption other = (HlsEncryption) obj;
        return Objects.equals(constantInitializationVector(), other.constantInitializationVector())
                && Objects.equals(encryptionMethodAsString(), other.encryptionMethodAsString())
                && Objects.equals(keyRotationIntervalSeconds(), other.keyRotationIntervalSeconds())
                && Objects.equals(repeatExtXKey(), other.repeatExtXKey())
                && Objects.equals(spekeKeyProvider(), other.spekeKeyProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HlsEncryption").add("ConstantInitializationVector", constantInitializationVector())
                .add("EncryptionMethod", encryptionMethodAsString())
                .add("KeyRotationIntervalSeconds", keyRotationIntervalSeconds()).add("RepeatExtXKey", repeatExtXKey())
                .add("SpekeKeyProvider", spekeKeyProvider()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConstantInitializationVector":
            return Optional.ofNullable(clazz.cast(constantInitializationVector()));
        case "EncryptionMethod":
            return Optional.ofNullable(clazz.cast(encryptionMethodAsString()));
        case "KeyRotationIntervalSeconds":
            return Optional.ofNullable(clazz.cast(keyRotationIntervalSeconds()));
        case "RepeatExtXKey":
            return Optional.ofNullable(clazz.cast(repeatExtXKey()));
        case "SpekeKeyProvider":
            return Optional.ofNullable(clazz.cast(spekeKeyProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsEncryption, T> g) {
        return obj -> g.apply((HlsEncryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsEncryption> {
        /**
         * A constant initialization vector for encryption (optional). When not specified the initialization vector will
         * be periodically rotated.
         *
         * @param constantInitializationVector
         *        A constant initialization vector for encryption (optional). When not specified the initialization
         *        vector will be periodically rotated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constantInitializationVector(String constantInitializationVector);

        /**
         * The encryption method to use.
         * 
         * @param encryptionMethod
         *        The encryption method to use.
         * @see EncryptionMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionMethod
         */
        Builder encryptionMethod(String encryptionMethod);

        /**
         * The encryption method to use.
         * 
         * @param encryptionMethod
         *        The encryption method to use.
         * @see EncryptionMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionMethod
         */
        Builder encryptionMethod(EncryptionMethod encryptionMethod);

        /**
         * Interval (in seconds) between each encryption key rotation.
         * 
         * @param keyRotationIntervalSeconds
         *        Interval (in seconds) between each encryption key rotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyRotationIntervalSeconds(Integer keyRotationIntervalSeconds);

        /**
         * When enabled, the EXT-X-KEY tag will be repeated in output manifests.
         * 
         * @param repeatExtXKey
         *        When enabled, the EXT-X-KEY tag will be repeated in output manifests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repeatExtXKey(Boolean repeatExtXKey);

        /**
         * Sets the value of the SpekeKeyProvider property for this object.
         *
         * @param spekeKeyProvider
         *        The new value for the SpekeKeyProvider property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider);

        /**
         * Sets the value of the SpekeKeyProvider property for this object.
         *
         * This is a convenience that creates an instance of the {@link SpekeKeyProvider.Builder} avoiding the need to
         * create one manually via {@link SpekeKeyProvider#builder()}.
         *
         * When the {@link Consumer} completes, {@link SpekeKeyProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #spekeKeyProvider(SpekeKeyProvider)}.
         * 
         * @param spekeKeyProvider
         *        a consumer that will call methods on {@link SpekeKeyProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spekeKeyProvider(SpekeKeyProvider)
         */
        default Builder spekeKeyProvider(Consumer<SpekeKeyProvider.Builder> spekeKeyProvider) {
            return spekeKeyProvider(SpekeKeyProvider.builder().applyMutation(spekeKeyProvider).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String constantInitializationVector;

        private String encryptionMethod;

        private Integer keyRotationIntervalSeconds;

        private Boolean repeatExtXKey;

        private SpekeKeyProvider spekeKeyProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsEncryption model) {
            constantInitializationVector(model.constantInitializationVector);
            encryptionMethod(model.encryptionMethod);
            keyRotationIntervalSeconds(model.keyRotationIntervalSeconds);
            repeatExtXKey(model.repeatExtXKey);
            spekeKeyProvider(model.spekeKeyProvider);
        }

        public final String getConstantInitializationVector() {
            return constantInitializationVector;
        }

        @Override
        public final Builder constantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
            return this;
        }

        public final void setConstantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
        }

        public final String getEncryptionMethod() {
            return encryptionMethod;
        }

        @Override
        public final Builder encryptionMethod(String encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
            return this;
        }

        @Override
        public final Builder encryptionMethod(EncryptionMethod encryptionMethod) {
            this.encryptionMethod(encryptionMethod == null ? null : encryptionMethod.toString());
            return this;
        }

        public final void setEncryptionMethod(String encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
        }

        public final Integer getKeyRotationIntervalSeconds() {
            return keyRotationIntervalSeconds;
        }

        @Override
        public final Builder keyRotationIntervalSeconds(Integer keyRotationIntervalSeconds) {
            this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
            return this;
        }

        public final void setKeyRotationIntervalSeconds(Integer keyRotationIntervalSeconds) {
            this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
        }

        public final Boolean getRepeatExtXKey() {
            return repeatExtXKey;
        }

        @Override
        public final Builder repeatExtXKey(Boolean repeatExtXKey) {
            this.repeatExtXKey = repeatExtXKey;
            return this;
        }

        public final void setRepeatExtXKey(Boolean repeatExtXKey) {
            this.repeatExtXKey = repeatExtXKey;
        }

        public final SpekeKeyProvider.Builder getSpekeKeyProvider() {
            return spekeKeyProvider != null ? spekeKeyProvider.toBuilder() : null;
        }

        @Override
        public final Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider;
            return this;
        }

        public final void setSpekeKeyProvider(SpekeKeyProvider.BuilderImpl spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider != null ? spekeKeyProvider.build() : null;
        }

        @Override
        public HlsEncryption build() {
            return new HlsEncryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
