/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackage.model.AdMarkers;
import software.amazon.awssdk.services.mediapackage.model.PlaylistType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsManifest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsManifest> {
    private static final SdkField<String> AD_MARKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsManifest.getter(HlsManifest::adMarkersAsString)).setter(HlsManifest.setter(Builder::adMarkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adMarkers").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsManifest.getter(HlsManifest::id)).setter(HlsManifest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Boolean> INCLUDE_IFRAME_ONLY_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(HlsManifest.getter(HlsManifest::includeIframeOnlyStream)).setter(HlsManifest.setter(Builder::includeIframeOnlyStream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeIframeOnlyStream").build()}).build();
    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsManifest.getter(HlsManifest::manifestName)).setter(HlsManifest.setter(Builder::manifestName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestName").build()}).build();
    private static final SdkField<String> PLAYLIST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsManifest.getter(HlsManifest::playlistTypeAsString)).setter(HlsManifest.setter(Builder::playlistType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playlistType").build()}).build();
    private static final SdkField<Integer> PLAYLIST_WINDOW_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(HlsManifest.getter(HlsManifest::playlistWindowSeconds)).setter(HlsManifest.setter(Builder::playlistWindowSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playlistWindowSeconds").build()}).build();
    private static final SdkField<Integer> PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(HlsManifest.getter(HlsManifest::programDateTimeIntervalSeconds)).setter(HlsManifest.setter(Builder::programDateTimeIntervalSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTimeIntervalSeconds").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsManifest.getter(HlsManifest::url)).setter(HlsManifest.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKERS_FIELD, ID_FIELD, INCLUDE_IFRAME_ONLY_STREAM_FIELD, MANIFEST_NAME_FIELD, PLAYLIST_TYPE_FIELD, PLAYLIST_WINDOW_SECONDS_FIELD, PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD, URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adMarkers;
    private final String id;
    private final Boolean includeIframeOnlyStream;
    private final String manifestName;
    private final String playlistType;
    private final Integer playlistWindowSeconds;
    private final Integer programDateTimeIntervalSeconds;
    private final String url;

    private HlsManifest(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.id = builder.id;
        this.includeIframeOnlyStream = builder.includeIframeOnlyStream;
        this.manifestName = builder.manifestName;
        this.playlistType = builder.playlistType;
        this.playlistWindowSeconds = builder.playlistWindowSeconds;
        this.programDateTimeIntervalSeconds = builder.programDateTimeIntervalSeconds;
        this.url = builder.url;
    }

    public AdMarkers adMarkers() {
        return AdMarkers.fromValue(this.adMarkers);
    }

    public String adMarkersAsString() {
        return this.adMarkers;
    }

    public String id() {
        return this.id;
    }

    public Boolean includeIframeOnlyStream() {
        return this.includeIframeOnlyStream;
    }

    public String manifestName() {
        return this.manifestName;
    }

    public PlaylistType playlistType() {
        return PlaylistType.fromValue(this.playlistType);
    }

    public String playlistTypeAsString() {
        return this.playlistType;
    }

    public Integer playlistWindowSeconds() {
        return this.playlistWindowSeconds;
    }

    public Integer programDateTimeIntervalSeconds() {
        return this.programDateTimeIntervalSeconds;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adMarkersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeIframeOnlyStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(this.playlistTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.playlistWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.programDateTimeIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsManifest)) {
            return false;
        }
        HlsManifest other = (HlsManifest)obj;
        return Objects.equals(this.adMarkersAsString(), other.adMarkersAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.includeIframeOnlyStream(), other.includeIframeOnlyStream()) && Objects.equals(this.manifestName(), other.manifestName()) && Objects.equals(this.playlistTypeAsString(), other.playlistTypeAsString()) && Objects.equals(this.playlistWindowSeconds(), other.playlistWindowSeconds()) && Objects.equals(this.programDateTimeIntervalSeconds(), other.programDateTimeIntervalSeconds()) && Objects.equals(this.url(), other.url());
    }

    public String toString() {
        return ToString.builder((String)"HlsManifest").add("AdMarkers", (Object)this.adMarkersAsString()).add("Id", (Object)this.id()).add("IncludeIframeOnlyStream", (Object)this.includeIframeOnlyStream()).add("ManifestName", (Object)this.manifestName()).add("PlaylistType", (Object)this.playlistTypeAsString()).add("PlaylistWindowSeconds", (Object)this.playlistWindowSeconds()).add("ProgramDateTimeIntervalSeconds", (Object)this.programDateTimeIntervalSeconds()).add("Url", (Object)this.url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdMarkers": {
                return Optional.ofNullable(clazz.cast(this.adMarkersAsString()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IncludeIframeOnlyStream": {
                return Optional.ofNullable(clazz.cast(this.includeIframeOnlyStream()));
            }
            case "ManifestName": {
                return Optional.ofNullable(clazz.cast(this.manifestName()));
            }
            case "PlaylistType": {
                return Optional.ofNullable(clazz.cast(this.playlistTypeAsString()));
            }
            case "PlaylistWindowSeconds": {
                return Optional.ofNullable(clazz.cast(this.playlistWindowSeconds()));
            }
            case "ProgramDateTimeIntervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.programDateTimeIntervalSeconds()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsManifest, T> g) {
        return obj -> g.apply((HlsManifest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adMarkers;
        private String id;
        private Boolean includeIframeOnlyStream;
        private String manifestName;
        private String playlistType;
        private Integer playlistWindowSeconds;
        private Integer programDateTimeIntervalSeconds;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsManifest model) {
            this.adMarkers(model.adMarkers);
            this.id(model.id);
            this.includeIframeOnlyStream(model.includeIframeOnlyStream);
            this.manifestName(model.manifestName);
            this.playlistType(model.playlistType);
            this.playlistWindowSeconds(model.playlistWindowSeconds);
            this.programDateTimeIntervalSeconds(model.programDateTimeIntervalSeconds);
            this.url(model.url);
        }

        public final String getAdMarkersAsString() {
            return this.adMarkers;
        }

        @Override
        public final Builder adMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
            return this;
        }

        @Override
        public final Builder adMarkers(AdMarkers adMarkers) {
            this.adMarkers(adMarkers == null ? null : adMarkers.toString());
            return this;
        }

        public final void setAdMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Boolean getIncludeIframeOnlyStream() {
            return this.includeIframeOnlyStream;
        }

        @Override
        public final Builder includeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
            return this;
        }

        public final void setIncludeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
        }

        public final String getManifestName() {
            return this.manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        public final String getPlaylistTypeAsString() {
            return this.playlistType;
        }

        @Override
        public final Builder playlistType(String playlistType) {
            this.playlistType = playlistType;
            return this;
        }

        @Override
        public final Builder playlistType(PlaylistType playlistType) {
            this.playlistType(playlistType == null ? null : playlistType.toString());
            return this;
        }

        public final void setPlaylistType(String playlistType) {
            this.playlistType = playlistType;
        }

        public final Integer getPlaylistWindowSeconds() {
            return this.playlistWindowSeconds;
        }

        @Override
        public final Builder playlistWindowSeconds(Integer playlistWindowSeconds) {
            this.playlistWindowSeconds = playlistWindowSeconds;
            return this;
        }

        public final void setPlaylistWindowSeconds(Integer playlistWindowSeconds) {
            this.playlistWindowSeconds = playlistWindowSeconds;
        }

        public final Integer getProgramDateTimeIntervalSeconds() {
            return this.programDateTimeIntervalSeconds;
        }

        @Override
        public final Builder programDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
            return this;
        }

        public final void setProgramDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public HlsManifest build() {
            return new HlsManifest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsManifest> {
        public Builder adMarkers(String var1);

        public Builder adMarkers(AdMarkers var1);

        public Builder id(String var1);

        public Builder includeIframeOnlyStream(Boolean var1);

        public Builder manifestName(String var1);

        public Builder playlistType(String var1);

        public Builder playlistType(PlaylistType var1);

        public Builder playlistWindowSeconds(Integer var1);

        public Builder programDateTimeIntervalSeconds(Integer var1);

        public Builder url(String var1);
    }
}

