/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType;
import software.amazon.awssdk.services.medialive.model.InputLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioOnlyHlsSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioOnlyHlsSettings> {
    private static final SdkField<String> AUDIO_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AudioOnlyHlsSettings.getter(AudioOnlyHlsSettings::audioGroupId)).setter(AudioOnlyHlsSettings.setter(Builder::audioGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioGroupId").build()}).build();
    private static final SdkField<InputLocation> AUDIO_ONLY_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AudioOnlyHlsSettings.getter(AudioOnlyHlsSettings::audioOnlyImage)).setter(AudioOnlyHlsSettings.setter(Builder::audioOnlyImage)).constructor(InputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioOnlyImage").build()}).build();
    private static final SdkField<String> AUDIO_TRACK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AudioOnlyHlsSettings.getter(AudioOnlyHlsSettings::audioTrackTypeAsString)).setter(AudioOnlyHlsSettings.setter(Builder::audioTrackType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioTrackType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_GROUP_ID_FIELD, AUDIO_ONLY_IMAGE_FIELD, AUDIO_TRACK_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String audioGroupId;
    private final InputLocation audioOnlyImage;
    private final String audioTrackType;

    private AudioOnlyHlsSettings(BuilderImpl builder) {
        this.audioGroupId = builder.audioGroupId;
        this.audioOnlyImage = builder.audioOnlyImage;
        this.audioTrackType = builder.audioTrackType;
    }

    public String audioGroupId() {
        return this.audioGroupId;
    }

    public InputLocation audioOnlyImage() {
        return this.audioOnlyImage;
    }

    public AudioOnlyHlsTrackType audioTrackType() {
        return AudioOnlyHlsTrackType.fromValue(this.audioTrackType);
    }

    public String audioTrackTypeAsString() {
        return this.audioTrackType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioOnlyImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioTrackTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioOnlyHlsSettings)) {
            return false;
        }
        AudioOnlyHlsSettings other = (AudioOnlyHlsSettings)obj;
        return Objects.equals(this.audioGroupId(), other.audioGroupId()) && Objects.equals(this.audioOnlyImage(), other.audioOnlyImage()) && Objects.equals(this.audioTrackTypeAsString(), other.audioTrackTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"AudioOnlyHlsSettings").add("AudioGroupId", (Object)this.audioGroupId()).add("AudioOnlyImage", (Object)this.audioOnlyImage()).add("AudioTrackType", (Object)this.audioTrackTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioGroupId": {
                return Optional.ofNullable(clazz.cast(this.audioGroupId()));
            }
            case "AudioOnlyImage": {
                return Optional.ofNullable(clazz.cast(this.audioOnlyImage()));
            }
            case "AudioTrackType": {
                return Optional.ofNullable(clazz.cast(this.audioTrackTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioOnlyHlsSettings, T> g) {
        return obj -> g.apply((AudioOnlyHlsSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioGroupId;
        private InputLocation audioOnlyImage;
        private String audioTrackType;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioOnlyHlsSettings model) {
            this.audioGroupId(model.audioGroupId);
            this.audioOnlyImage(model.audioOnlyImage);
            this.audioTrackType(model.audioTrackType);
        }

        public final String getAudioGroupId() {
            return this.audioGroupId;
        }

        @Override
        public final Builder audioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
            return this;
        }

        public final void setAudioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
        }

        public final InputLocation.Builder getAudioOnlyImage() {
            return this.audioOnlyImage != null ? this.audioOnlyImage.toBuilder() : null;
        }

        @Override
        public final Builder audioOnlyImage(InputLocation audioOnlyImage) {
            this.audioOnlyImage = audioOnlyImage;
            return this;
        }

        public final void setAudioOnlyImage(InputLocation.BuilderImpl audioOnlyImage) {
            this.audioOnlyImage = audioOnlyImage != null ? audioOnlyImage.build() : null;
        }

        public final String getAudioTrackTypeAsString() {
            return this.audioTrackType;
        }

        @Override
        public final Builder audioTrackType(String audioTrackType) {
            this.audioTrackType = audioTrackType;
            return this;
        }

        @Override
        public final Builder audioTrackType(AudioOnlyHlsTrackType audioTrackType) {
            this.audioTrackType(audioTrackType.toString());
            return this;
        }

        public final void setAudioTrackType(String audioTrackType) {
            this.audioTrackType = audioTrackType;
        }

        public AudioOnlyHlsSettings build() {
            return new AudioOnlyHlsSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioOnlyHlsSettings> {
        public Builder audioGroupId(String var1);

        public Builder audioOnlyImage(InputLocation var1);

        default public Builder audioOnlyImage(Consumer<InputLocation.Builder> audioOnlyImage) {
            return this.audioOnlyImage((InputLocation)((InputLocation.Builder)InputLocation.builder().applyMutation(audioOnlyImage)).build());
        }

        public Builder audioTrackType(String var1);

        public Builder audioTrackType(AudioOnlyHlsTrackType var1);
    }
}

