/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AudioLanguageSelectionPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioLanguageSelection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioLanguageSelection> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AudioLanguageSelection.getter(AudioLanguageSelection::languageCode)).setter(AudioLanguageSelection.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()}).build();
    private static final SdkField<String> LANGUAGE_SELECTION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AudioLanguageSelection.getter(AudioLanguageSelection::languageSelectionPolicyAsString)).setter(AudioLanguageSelection.setter(Builder::languageSelectionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageSelectionPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD, LANGUAGE_SELECTION_POLICY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String languageCode;
    private final String languageSelectionPolicy;

    private AudioLanguageSelection(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.languageSelectionPolicy = builder.languageSelectionPolicy;
    }

    public String languageCode() {
        return this.languageCode;
    }

    public AudioLanguageSelectionPolicy languageSelectionPolicy() {
        return AudioLanguageSelectionPolicy.fromValue(this.languageSelectionPolicy);
    }

    public String languageSelectionPolicyAsString() {
        return this.languageSelectionPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageSelectionPolicyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioLanguageSelection)) {
            return false;
        }
        AudioLanguageSelection other = (AudioLanguageSelection)obj;
        return Objects.equals(this.languageCode(), other.languageCode()) && Objects.equals(this.languageSelectionPolicyAsString(), other.languageSelectionPolicyAsString());
    }

    public String toString() {
        return ToString.builder((String)"AudioLanguageSelection").add("LanguageCode", (Object)this.languageCode()).add("LanguageSelectionPolicy", (Object)this.languageSelectionPolicyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCode()));
            }
            case "LanguageSelectionPolicy": {
                return Optional.ofNullable(clazz.cast(this.languageSelectionPolicyAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioLanguageSelection, T> g) {
        return obj -> g.apply((AudioLanguageSelection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String languageCode;
        private String languageSelectionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioLanguageSelection model) {
            this.languageCode(model.languageCode);
            this.languageSelectionPolicy(model.languageSelectionPolicy);
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getLanguageSelectionPolicyAsString() {
            return this.languageSelectionPolicy;
        }

        @Override
        public final Builder languageSelectionPolicy(String languageSelectionPolicy) {
            this.languageSelectionPolicy = languageSelectionPolicy;
            return this;
        }

        @Override
        public final Builder languageSelectionPolicy(AudioLanguageSelectionPolicy languageSelectionPolicy) {
            this.languageSelectionPolicy(languageSelectionPolicy.toString());
            return this;
        }

        public final void setLanguageSelectionPolicy(String languageSelectionPolicy) {
            this.languageSelectionPolicy = languageSelectionPolicy;
        }

        public AudioLanguageSelection build() {
            return new AudioLanguageSelection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioLanguageSelection> {
        public Builder languageCode(String var1);

        public Builder languageSelectionPolicy(String var1);

        public Builder languageSelectionPolicy(AudioLanguageSelectionPolicy var1);
    }
}

