/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.InputClass;
import software.amazon.awssdk.services.medialive.model.InputDestination;
import software.amazon.awssdk.services.medialive.model.InputSource;
import software.amazon.awssdk.services.medialive.model.InputState;
import software.amazon.awssdk.services.medialive.model.InputType;
import software.amazon.awssdk.services.medialive.model.MediaConnectFlow;
import software.amazon.awssdk.services.medialive.model.TagsCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputDestinationCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputSourceCopier;
import software.amazon.awssdk.services.medialive.model.___listOfMediaConnectFlowCopier;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Input
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Input> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Input.getter(Input::arn)).setter(Input.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<String>> ATTACHED_CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Input.getter(Input::attachedChannels)).setter(Input.setter(Builder::attachedChannels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedChannels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InputDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Input.getter(Input::destinations)).setter(Input.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Input.getter(Input::id)).setter(Input.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> INPUT_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Input.getter(Input::inputClassAsString)).setter(Input.setter(Builder::inputClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputClass").build()}).build();
    private static final SdkField<List<MediaConnectFlow>> MEDIA_CONNECT_FLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Input.getter(Input::mediaConnectFlows)).setter(Input.setter(Builder::mediaConnectFlows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaConnectFlows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaConnectFlow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Input.getter(Input::name)).setter(Input.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Input.getter(Input::roleArn)).setter(Input.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Input.getter(Input::securityGroups)).setter(Input.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InputSource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Input.getter(Input::sources)).setter(Input.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Input.getter(Input::stateAsString)).setter(Input.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Input.getter(Input::tags)).setter(Input.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Input.getter(Input::typeAsString)).setter(Input.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ATTACHED_CHANNELS_FIELD, DESTINATIONS_FIELD, ID_FIELD, INPUT_CLASS_FIELD, MEDIA_CONNECT_FLOWS_FIELD, NAME_FIELD, ROLE_ARN_FIELD, SECURITY_GROUPS_FIELD, SOURCES_FIELD, STATE_FIELD, TAGS_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<String> attachedChannels;
    private final List<InputDestination> destinations;
    private final String id;
    private final String inputClass;
    private final List<MediaConnectFlow> mediaConnectFlows;
    private final String name;
    private final String roleArn;
    private final List<String> securityGroups;
    private final List<InputSource> sources;
    private final String state;
    private final Map<String, String> tags;
    private final String type;

    private Input(BuilderImpl builder) {
        this.arn = builder.arn;
        this.attachedChannels = builder.attachedChannels;
        this.destinations = builder.destinations;
        this.id = builder.id;
        this.inputClass = builder.inputClass;
        this.mediaConnectFlows = builder.mediaConnectFlows;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.securityGroups = builder.securityGroups;
        this.sources = builder.sources;
        this.state = builder.state;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    public String arn() {
        return this.arn;
    }

    public List<String> attachedChannels() {
        return this.attachedChannels;
    }

    public List<InputDestination> destinations() {
        return this.destinations;
    }

    public String id() {
        return this.id;
    }

    public InputClass inputClass() {
        return InputClass.fromValue(this.inputClass);
    }

    public String inputClassAsString() {
        return this.inputClass;
    }

    public List<MediaConnectFlow> mediaConnectFlows() {
        return this.mediaConnectFlows;
    }

    public String name() {
        return this.name;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public List<InputSource> sources() {
        return this.sources;
    }

    public InputState state() {
        return InputState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public InputType type() {
        return InputType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedChannels());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinations());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaConnectFlows());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.sources());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Input)) {
            return false;
        }
        Input other = (Input)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.attachedChannels(), other.attachedChannels()) && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.inputClassAsString(), other.inputClassAsString()) && Objects.equals(this.mediaConnectFlows(), other.mediaConnectFlows()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Input").add("Arn", (Object)this.arn()).add("AttachedChannels", this.attachedChannels()).add("Destinations", this.destinations()).add("Id", (Object)this.id()).add("InputClass", (Object)this.inputClassAsString()).add("MediaConnectFlows", this.mediaConnectFlows()).add("Name", (Object)this.name()).add("RoleArn", (Object)this.roleArn()).add("SecurityGroups", this.securityGroups()).add("Sources", this.sources()).add("State", (Object)this.stateAsString()).add("Tags", this.tags()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AttachedChannels": {
                return Optional.ofNullable(clazz.cast(this.attachedChannels()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "InputClass": {
                return Optional.ofNullable(clazz.cast(this.inputClassAsString()));
            }
            case "MediaConnectFlows": {
                return Optional.ofNullable(clazz.cast(this.mediaConnectFlows()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Input, T> g) {
        return obj -> g.apply((Input)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<String> attachedChannels = DefaultSdkAutoConstructList.getInstance();
        private List<InputDestination> destinations = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private String inputClass;
        private List<MediaConnectFlow> mediaConnectFlows = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String roleArn;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<InputSource> sources = DefaultSdkAutoConstructList.getInstance();
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Input model) {
            this.arn(model.arn);
            this.attachedChannels(model.attachedChannels);
            this.destinations(model.destinations);
            this.id(model.id);
            this.inputClass(model.inputClass);
            this.mediaConnectFlows(model.mediaConnectFlows);
            this.name(model.name);
            this.roleArn(model.roleArn);
            this.securityGroups(model.securityGroups);
            this.sources(model.sources);
            this.state(model.state);
            this.tags(model.tags);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<String> getAttachedChannels() {
            return this.attachedChannels;
        }

        @Override
        public final Builder attachedChannels(Collection<String> attachedChannels) {
            this.attachedChannels = ___listOf__stringCopier.copy(attachedChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedChannels(String ... attachedChannels) {
            this.attachedChannels(Arrays.asList(attachedChannels));
            return this;
        }

        public final void setAttachedChannels(Collection<String> attachedChannels) {
            this.attachedChannels = ___listOf__stringCopier.copy(attachedChannels);
        }

        public final Collection<InputDestination.Builder> getDestinations() {
            return this.destinations != null ? (Collection)this.destinations.stream().map(InputDestination::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<InputDestination> destinations) {
            this.destinations = ___listOfInputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(InputDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<InputDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (InputDestination)((InputDestination.Builder)InputDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<InputDestination.BuilderImpl> destinations) {
            this.destinations = ___listOfInputDestinationCopier.copyFromBuilder(destinations);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getInputClassAsString() {
            return this.inputClass;
        }

        @Override
        public final Builder inputClass(String inputClass) {
            this.inputClass = inputClass;
            return this;
        }

        @Override
        public final Builder inputClass(InputClass inputClass) {
            this.inputClass(inputClass.toString());
            return this;
        }

        public final void setInputClass(String inputClass) {
            this.inputClass = inputClass;
        }

        public final Collection<MediaConnectFlow.Builder> getMediaConnectFlows() {
            return this.mediaConnectFlows != null ? (Collection)this.mediaConnectFlows.stream().map(MediaConnectFlow::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mediaConnectFlows(Collection<MediaConnectFlow> mediaConnectFlows) {
            this.mediaConnectFlows = ___listOfMediaConnectFlowCopier.copy(mediaConnectFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConnectFlows(MediaConnectFlow ... mediaConnectFlows) {
            this.mediaConnectFlows(Arrays.asList(mediaConnectFlows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConnectFlows(Consumer<MediaConnectFlow.Builder> ... mediaConnectFlows) {
            this.mediaConnectFlows(Stream.of(mediaConnectFlows).map(c -> (MediaConnectFlow)((MediaConnectFlow.Builder)MediaConnectFlow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMediaConnectFlows(Collection<MediaConnectFlow.BuilderImpl> mediaConnectFlows) {
            this.mediaConnectFlows = ___listOfMediaConnectFlowCopier.copyFromBuilder(mediaConnectFlows);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        public final Collection<InputSource.Builder> getSources() {
            return this.sources != null ? (Collection)this.sources.stream().map(InputSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sources(Collection<InputSource> sources) {
            this.sources = ___listOfInputSourceCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(InputSource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<InputSource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (InputSource)((InputSource.Builder)InputSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<InputSource.BuilderImpl> sources) {
            this.sources = ___listOfInputSourceCopier.copyFromBuilder(sources);
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InputState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InputType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public Input build() {
            return new Input(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Input> {
        public Builder arn(String var1);

        public Builder attachedChannels(Collection<String> var1);

        public Builder attachedChannels(String ... var1);

        public Builder destinations(Collection<InputDestination> var1);

        public Builder destinations(InputDestination ... var1);

        public Builder destinations(Consumer<InputDestination.Builder> ... var1);

        public Builder id(String var1);

        public Builder inputClass(String var1);

        public Builder inputClass(InputClass var1);

        public Builder mediaConnectFlows(Collection<MediaConnectFlow> var1);

        public Builder mediaConnectFlows(MediaConnectFlow ... var1);

        public Builder mediaConnectFlows(Consumer<MediaConnectFlow.Builder> ... var1);

        public Builder name(String var1);

        public Builder roleArn(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder sources(Collection<InputSource> var1);

        public Builder sources(InputSource ... var1);

        public Builder sources(Consumer<InputSource.Builder> ... var1);

        public Builder state(String var1);

        public Builder state(InputState var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(InputType var1);
    }
}

