/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.BlackoutSlateNetworkEndBlackout;
import software.amazon.awssdk.services.medialive.model.BlackoutSlateState;
import software.amazon.awssdk.services.medialive.model.InputLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlackoutSlate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BlackoutSlate> {
    private static final SdkField<InputLocation> BLACKOUT_SLATE_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BlackoutSlate.getter(BlackoutSlate::blackoutSlateImage)).setter(BlackoutSlate.setter(Builder::blackoutSlateImage)).constructor(InputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blackoutSlateImage").build()}).build();
    private static final SdkField<String> NETWORK_END_BLACKOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BlackoutSlate.getter(BlackoutSlate::networkEndBlackoutAsString)).setter(BlackoutSlate.setter(Builder::networkEndBlackout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkEndBlackout").build()}).build();
    private static final SdkField<InputLocation> NETWORK_END_BLACKOUT_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BlackoutSlate.getter(BlackoutSlate::networkEndBlackoutImage)).setter(BlackoutSlate.setter(Builder::networkEndBlackoutImage)).constructor(InputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkEndBlackoutImage").build()}).build();
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BlackoutSlate.getter(BlackoutSlate::networkId)).setter(BlackoutSlate.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BlackoutSlate.getter(BlackoutSlate::stateAsString)).setter(BlackoutSlate.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLACKOUT_SLATE_IMAGE_FIELD, NETWORK_END_BLACKOUT_FIELD, NETWORK_END_BLACKOUT_IMAGE_FIELD, NETWORK_ID_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final InputLocation blackoutSlateImage;
    private final String networkEndBlackout;
    private final InputLocation networkEndBlackoutImage;
    private final String networkId;
    private final String state;

    private BlackoutSlate(BuilderImpl builder) {
        this.blackoutSlateImage = builder.blackoutSlateImage;
        this.networkEndBlackout = builder.networkEndBlackout;
        this.networkEndBlackoutImage = builder.networkEndBlackoutImage;
        this.networkId = builder.networkId;
        this.state = builder.state;
    }

    public InputLocation blackoutSlateImage() {
        return this.blackoutSlateImage;
    }

    public BlackoutSlateNetworkEndBlackout networkEndBlackout() {
        return BlackoutSlateNetworkEndBlackout.fromValue(this.networkEndBlackout);
    }

    public String networkEndBlackoutAsString() {
        return this.networkEndBlackout;
    }

    public InputLocation networkEndBlackoutImage() {
        return this.networkEndBlackoutImage;
    }

    public String networkId() {
        return this.networkId;
    }

    public BlackoutSlateState state() {
        return BlackoutSlateState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blackoutSlateImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkEndBlackoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkEndBlackoutImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlackoutSlate)) {
            return false;
        }
        BlackoutSlate other = (BlackoutSlate)obj;
        return Objects.equals(this.blackoutSlateImage(), other.blackoutSlateImage()) && Objects.equals(this.networkEndBlackoutAsString(), other.networkEndBlackoutAsString()) && Objects.equals(this.networkEndBlackoutImage(), other.networkEndBlackoutImage()) && Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public String toString() {
        return ToString.builder((String)"BlackoutSlate").add("BlackoutSlateImage", (Object)this.blackoutSlateImage()).add("NetworkEndBlackout", (Object)this.networkEndBlackoutAsString()).add("NetworkEndBlackoutImage", (Object)this.networkEndBlackoutImage()).add("NetworkId", (Object)this.networkId()).add("State", (Object)this.stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlackoutSlateImage": {
                return Optional.ofNullable(clazz.cast(this.blackoutSlateImage()));
            }
            case "NetworkEndBlackout": {
                return Optional.ofNullable(clazz.cast(this.networkEndBlackoutAsString()));
            }
            case "NetworkEndBlackoutImage": {
                return Optional.ofNullable(clazz.cast(this.networkEndBlackoutImage()));
            }
            case "NetworkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlackoutSlate, T> g) {
        return obj -> g.apply((BlackoutSlate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InputLocation blackoutSlateImage;
        private String networkEndBlackout;
        private InputLocation networkEndBlackoutImage;
        private String networkId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(BlackoutSlate model) {
            this.blackoutSlateImage(model.blackoutSlateImage);
            this.networkEndBlackout(model.networkEndBlackout);
            this.networkEndBlackoutImage(model.networkEndBlackoutImage);
            this.networkId(model.networkId);
            this.state(model.state);
        }

        public final InputLocation.Builder getBlackoutSlateImage() {
            return this.blackoutSlateImage != null ? this.blackoutSlateImage.toBuilder() : null;
        }

        @Override
        public final Builder blackoutSlateImage(InputLocation blackoutSlateImage) {
            this.blackoutSlateImage = blackoutSlateImage;
            return this;
        }

        public final void setBlackoutSlateImage(InputLocation.BuilderImpl blackoutSlateImage) {
            this.blackoutSlateImage = blackoutSlateImage != null ? blackoutSlateImage.build() : null;
        }

        public final String getNetworkEndBlackoutAsString() {
            return this.networkEndBlackout;
        }

        @Override
        public final Builder networkEndBlackout(String networkEndBlackout) {
            this.networkEndBlackout = networkEndBlackout;
            return this;
        }

        @Override
        public final Builder networkEndBlackout(BlackoutSlateNetworkEndBlackout networkEndBlackout) {
            this.networkEndBlackout(networkEndBlackout.toString());
            return this;
        }

        public final void setNetworkEndBlackout(String networkEndBlackout) {
            this.networkEndBlackout = networkEndBlackout;
        }

        public final InputLocation.Builder getNetworkEndBlackoutImage() {
            return this.networkEndBlackoutImage != null ? this.networkEndBlackoutImage.toBuilder() : null;
        }

        @Override
        public final Builder networkEndBlackoutImage(InputLocation networkEndBlackoutImage) {
            this.networkEndBlackoutImage = networkEndBlackoutImage;
            return this;
        }

        public final void setNetworkEndBlackoutImage(InputLocation.BuilderImpl networkEndBlackoutImage) {
            this.networkEndBlackoutImage = networkEndBlackoutImage != null ? networkEndBlackoutImage.build() : null;
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(BlackoutSlateState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public BlackoutSlate build() {
            return new BlackoutSlate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BlackoutSlate> {
        public Builder blackoutSlateImage(InputLocation var1);

        default public Builder blackoutSlateImage(Consumer<InputLocation.Builder> blackoutSlateImage) {
            return this.blackoutSlateImage((InputLocation)((InputLocation.Builder)InputLocation.builder().applyMutation(blackoutSlateImage)).build());
        }

        public Builder networkEndBlackout(String var1);

        public Builder networkEndBlackout(BlackoutSlateNetworkEndBlackout var1);

        public Builder networkEndBlackoutImage(InputLocation var1);

        default public Builder networkEndBlackoutImage(Consumer<InputLocation.Builder> networkEndBlackoutImage) {
            return this.networkEndBlackoutImage((InputLocation)((InputLocation.Builder)InputLocation.builder().applyMutation(networkEndBlackoutImage)).build());
        }

        public Builder networkId(String var1);

        public Builder state(String var1);

        public Builder state(BlackoutSlateState var1);
    }
}

