/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.model.ListOfferingsRequest;
import software.amazon.awssdk.services.medialive.model.ListOfferingsResponse;

public class ListOfferingsIterable
implements SdkIterable<ListOfferingsResponse> {
    private final MediaLiveClient client;
    private final ListOfferingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOfferingsIterable(MediaLiveClient client, ListOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOfferingsResponseFetcher();
    }

    public Iterator<ListOfferingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListOfferingsResponseFetcher
    implements SyncPageFetcher<ListOfferingsResponse> {
        private ListOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(ListOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOfferingsResponse nextPage(ListOfferingsResponse previousPage) {
            if (previousPage == null) {
                return ListOfferingsIterable.this.client.listOfferings(ListOfferingsIterable.this.firstRequest);
            }
            return ListOfferingsIterable.this.client.listOfferings((ListOfferingsRequest)((Object)ListOfferingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

