/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.model.ListInputsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputsResponse;

public class ListInputsPublisher
implements SdkPublisher<ListInputsResponse> {
    private final MediaLiveAsyncClient client;
    private final ListInputsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInputsPublisher(MediaLiveAsyncClient client, ListInputsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInputsPublisher(MediaLiveAsyncClient client, ListInputsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInputsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInputsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListInputsResponseFetcher
    implements AsyncPageFetcher<ListInputsResponse> {
        private ListInputsResponseFetcher() {
        }

        public boolean hasNextPage(ListInputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInputsResponse> nextPage(ListInputsResponse previousPage) {
            if (previousPage == null) {
                return ListInputsPublisher.this.client.listInputs(ListInputsPublisher.this.firstRequest);
            }
            return ListInputsPublisher.this.client.listInputs((ListInputsRequest)((Object)ListInputsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

