/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.InputLossActionForUdpOut;
import software.amazon.awssdk.services.medialive.model.UdpTimedMetadataId3Frame;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UdpGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UdpGroupSettings> {
    private static final SdkField<String> INPUT_LOSS_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UdpGroupSettings.getter(UdpGroupSettings::inputLossActionAsString)).setter(UdpGroupSettings.setter(Builder::inputLossAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossAction").build()}).build();
    private static final SdkField<String> TIMED_METADATA_ID3_FRAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UdpGroupSettings.getter(UdpGroupSettings::timedMetadataId3FrameAsString)).setter(UdpGroupSettings.setter(Builder::timedMetadataId3Frame)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Frame").build()}).build();
    private static final SdkField<Integer> TIMED_METADATA_ID3_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UdpGroupSettings.getter(UdpGroupSettings::timedMetadataId3Period)).setter(UdpGroupSettings.setter(Builder::timedMetadataId3Period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Period").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_LOSS_ACTION_FIELD, TIMED_METADATA_ID3_FRAME_FIELD, TIMED_METADATA_ID3_PERIOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputLossAction;
    private final String timedMetadataId3Frame;
    private final Integer timedMetadataId3Period;

    private UdpGroupSettings(BuilderImpl builder) {
        this.inputLossAction = builder.inputLossAction;
        this.timedMetadataId3Frame = builder.timedMetadataId3Frame;
        this.timedMetadataId3Period = builder.timedMetadataId3Period;
    }

    public InputLossActionForUdpOut inputLossAction() {
        return InputLossActionForUdpOut.fromValue(this.inputLossAction);
    }

    public String inputLossActionAsString() {
        return this.inputLossAction;
    }

    public UdpTimedMetadataId3Frame timedMetadataId3Frame() {
        return UdpTimedMetadataId3Frame.fromValue(this.timedMetadataId3Frame);
    }

    public String timedMetadataId3FrameAsString() {
        return this.timedMetadataId3Frame;
    }

    public Integer timedMetadataId3Period() {
        return this.timedMetadataId3Period;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLossActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataId3FrameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataId3Period());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UdpGroupSettings)) {
            return false;
        }
        UdpGroupSettings other = (UdpGroupSettings)obj;
        return Objects.equals(this.inputLossActionAsString(), other.inputLossActionAsString()) && Objects.equals(this.timedMetadataId3FrameAsString(), other.timedMetadataId3FrameAsString()) && Objects.equals(this.timedMetadataId3Period(), other.timedMetadataId3Period());
    }

    public String toString() {
        return ToString.builder((String)"UdpGroupSettings").add("InputLossAction", (Object)this.inputLossActionAsString()).add("TimedMetadataId3Frame", (Object)this.timedMetadataId3FrameAsString()).add("TimedMetadataId3Period", (Object)this.timedMetadataId3Period()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputLossAction": {
                return Optional.ofNullable(clazz.cast(this.inputLossActionAsString()));
            }
            case "TimedMetadataId3Frame": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataId3FrameAsString()));
            }
            case "TimedMetadataId3Period": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataId3Period()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UdpGroupSettings, T> g) {
        return obj -> g.apply((UdpGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputLossAction;
        private String timedMetadataId3Frame;
        private Integer timedMetadataId3Period;

        private BuilderImpl() {
        }

        private BuilderImpl(UdpGroupSettings model) {
            this.inputLossAction(model.inputLossAction);
            this.timedMetadataId3Frame(model.timedMetadataId3Frame);
            this.timedMetadataId3Period(model.timedMetadataId3Period);
        }

        public final String getInputLossActionAsString() {
            return this.inputLossAction;
        }

        @Override
        public final Builder inputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
            return this;
        }

        @Override
        public final Builder inputLossAction(InputLossActionForUdpOut inputLossAction) {
            this.inputLossAction(inputLossAction.toString());
            return this;
        }

        public final void setInputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
        }

        public final String getTimedMetadataId3FrameAsString() {
            return this.timedMetadataId3Frame;
        }

        @Override
        public final Builder timedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
            return this;
        }

        @Override
        public final Builder timedMetadataId3Frame(UdpTimedMetadataId3Frame timedMetadataId3Frame) {
            this.timedMetadataId3Frame(timedMetadataId3Frame.toString());
            return this;
        }

        public final void setTimedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
        }

        public final Integer getTimedMetadataId3Period() {
            return this.timedMetadataId3Period;
        }

        @Override
        public final Builder timedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
            return this;
        }

        public final void setTimedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
        }

        public UdpGroupSettings build() {
            return new UdpGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UdpGroupSettings> {
        public Builder inputLossAction(String var1);

        public Builder inputLossAction(InputLossActionForUdpOut var1);

        public Builder timedMetadataId3Frame(String var1);

        public Builder timedMetadataId3Frame(UdpTimedMetadataId3Frame var1);

        public Builder timedMetadataId3Period(Integer var1);
    }
}

