/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.OfferingDurationUnits;
import software.amazon.awssdk.services.medialive.model.OfferingType;
import software.amazon.awssdk.services.medialive.model.ReservationResourceSpecification;
import software.amazon.awssdk.services.medialive.model.ReservationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservationResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, DescribeReservationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservationResponse.getter(DescribeReservationResponse::arn)).setter(DescribeReservationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeReservationResponse.getter(DescribeReservationResponse::count)).setter(DescribeReservationResponse.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservationResponse.getter(DescribeReservationResponse::currencyCode)).setter(DescribeReservationResponse.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeReservationResponse.getter(DescribeReservationResponse::duration)).setter(DescribeReservationResponse.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()}).build();
    private static final SdkField<String> DURATION_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservationResponse.getter(DescribeReservationResponse::durationUnitsAsString)).setter(DescribeReservationResponse.setter(Builder::durationUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationUnits").build()}).build();
    private static final SdkField<String> END_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservationResponse.getter(DescribeReservationResponse::end)).setter(DescribeReservationResponse.setter(Builder::end)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()}).build();
    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(DescribeReservationResponse.getter(DescribeReservationResponse::fixedPrice)).setter(DescribeReservationResponse.setter(Builder::fixedPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedPrice").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservationResponse.getter(DescribeReservationResponse::name)).setter(DescribeReservationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OFFERING_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservationResponse.getter(DescribeReservationResponse::offeringDescription)).setter(DescribeReservationResponse.setter(Builder::offeringDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringDescription").build()}).build();
    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservationResponse.getter(DescribeReservationResponse::offeringId)).setter(DescribeReservationResponse.setter(Builder::offeringId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringId").build()}).build();
    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservationResponse.getter(DescribeReservationResponse::offeringTypeAsString)).setter(DescribeReservationResponse.setter(Builder::offeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringType").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservationResponse.getter(DescribeReservationResponse::region)).setter(DescribeReservationResponse.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservationResponse.getter(DescribeReservationResponse::reservationId)).setter(DescribeReservationResponse.setter(Builder::reservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationId").build()}).build();
    private static final SdkField<ReservationResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeReservationResponse.getter(DescribeReservationResponse::resourceSpecification)).setter(DescribeReservationResponse.setter(Builder::resourceSpecification)).constructor(ReservationResourceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build()}).build();
    private static final SdkField<String> START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservationResponse.getter(DescribeReservationResponse::start)).setter(DescribeReservationResponse.setter(Builder::start)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservationResponse.getter(DescribeReservationResponse::stateAsString)).setter(DescribeReservationResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(DescribeReservationResponse.getter(DescribeReservationResponse::usagePrice)).setter(DescribeReservationResponse.setter(Builder::usagePrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usagePrice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COUNT_FIELD, CURRENCY_CODE_FIELD, DURATION_FIELD, DURATION_UNITS_FIELD, END_FIELD, FIXED_PRICE_FIELD, NAME_FIELD, OFFERING_DESCRIPTION_FIELD, OFFERING_ID_FIELD, OFFERING_TYPE_FIELD, REGION_FIELD, RESERVATION_ID_FIELD, RESOURCE_SPECIFICATION_FIELD, START_FIELD, STATE_FIELD, USAGE_PRICE_FIELD));
    private final String arn;
    private final Integer count;
    private final String currencyCode;
    private final Integer duration;
    private final String durationUnits;
    private final String end;
    private final Double fixedPrice;
    private final String name;
    private final String offeringDescription;
    private final String offeringId;
    private final String offeringType;
    private final String region;
    private final String reservationId;
    private final ReservationResourceSpecification resourceSpecification;
    private final String start;
    private final String state;
    private final Double usagePrice;

    private DescribeReservationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.count = builder.count;
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.durationUnits = builder.durationUnits;
        this.end = builder.end;
        this.fixedPrice = builder.fixedPrice;
        this.name = builder.name;
        this.offeringDescription = builder.offeringDescription;
        this.offeringId = builder.offeringId;
        this.offeringType = builder.offeringType;
        this.region = builder.region;
        this.reservationId = builder.reservationId;
        this.resourceSpecification = builder.resourceSpecification;
        this.start = builder.start;
        this.state = builder.state;
        this.usagePrice = builder.usagePrice;
    }

    public String arn() {
        return this.arn;
    }

    public Integer count() {
        return this.count;
    }

    public String currencyCode() {
        return this.currencyCode;
    }

    public Integer duration() {
        return this.duration;
    }

    public OfferingDurationUnits durationUnits() {
        return OfferingDurationUnits.fromValue(this.durationUnits);
    }

    public String durationUnitsAsString() {
        return this.durationUnits;
    }

    public String end() {
        return this.end;
    }

    public Double fixedPrice() {
        return this.fixedPrice;
    }

    public String name() {
        return this.name;
    }

    public String offeringDescription() {
        return this.offeringDescription;
    }

    public String offeringId() {
        return this.offeringId;
    }

    public OfferingType offeringType() {
        return OfferingType.fromValue(this.offeringType);
    }

    public String offeringTypeAsString() {
        return this.offeringType;
    }

    public String region() {
        return this.region;
    }

    public String reservationId() {
        return this.reservationId;
    }

    public ReservationResourceSpecification resourceSpecification() {
        return this.resourceSpecification;
    }

    public String start() {
        return this.start;
    }

    public ReservationState state() {
        return ReservationState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Double usagePrice() {
        return this.usagePrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.end());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePrice());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservationResponse)) {
            return false;
        }
        DescribeReservationResponse other = (DescribeReservationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.durationUnitsAsString(), other.durationUnitsAsString()) && Objects.equals(this.end(), other.end()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.offeringDescription(), other.offeringDescription()) && Objects.equals(this.offeringId(), other.offeringId()) && Objects.equals(this.offeringTypeAsString(), other.offeringTypeAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.reservationId(), other.reservationId()) && Objects.equals(this.resourceSpecification(), other.resourceSpecification()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.usagePrice(), other.usagePrice());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservationResponse").add("Arn", (Object)this.arn()).add("Count", (Object)this.count()).add("CurrencyCode", (Object)this.currencyCode()).add("Duration", (Object)this.duration()).add("DurationUnits", (Object)this.durationUnitsAsString()).add("End", (Object)this.end()).add("FixedPrice", (Object)this.fixedPrice()).add("Name", (Object)this.name()).add("OfferingDescription", (Object)this.offeringDescription()).add("OfferingId", (Object)this.offeringId()).add("OfferingType", (Object)this.offeringTypeAsString()).add("Region", (Object)this.region()).add("ReservationId", (Object)this.reservationId()).add("ResourceSpecification", (Object)this.resourceSpecification()).add("Start", (Object)this.start()).add("State", (Object)this.stateAsString()).add("UsagePrice", (Object)this.usagePrice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "DurationUnits": {
                return Optional.ofNullable(clazz.cast(this.durationUnitsAsString()));
            }
            case "End": {
                return Optional.ofNullable(clazz.cast(this.end()));
            }
            case "FixedPrice": {
                return Optional.ofNullable(clazz.cast(this.fixedPrice()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OfferingDescription": {
                return Optional.ofNullable(clazz.cast(this.offeringDescription()));
            }
            case "OfferingId": {
                return Optional.ofNullable(clazz.cast(this.offeringId()));
            }
            case "OfferingType": {
                return Optional.ofNullable(clazz.cast(this.offeringTypeAsString()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "ReservationId": {
                return Optional.ofNullable(clazz.cast(this.reservationId()));
            }
            case "ResourceSpecification": {
                return Optional.ofNullable(clazz.cast(this.resourceSpecification()));
            }
            case "Start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "UsagePrice": {
                return Optional.ofNullable(clazz.cast(this.usagePrice()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservationResponse, T> g) {
        return obj -> g.apply((DescribeReservationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Integer count;
        private String currencyCode;
        private Integer duration;
        private String durationUnits;
        private String end;
        private Double fixedPrice;
        private String name;
        private String offeringDescription;
        private String offeringId;
        private String offeringType;
        private String region;
        private String reservationId;
        private ReservationResourceSpecification resourceSpecification;
        private String start;
        private String state;
        private Double usagePrice;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservationResponse model) {
            super(model);
            this.arn(model.arn);
            this.count(model.count);
            this.currencyCode(model.currencyCode);
            this.duration(model.duration);
            this.durationUnits(model.durationUnits);
            this.end(model.end);
            this.fixedPrice(model.fixedPrice);
            this.name(model.name);
            this.offeringDescription(model.offeringDescription);
            this.offeringId(model.offeringId);
            this.offeringType(model.offeringType);
            this.region(model.region);
            this.reservationId(model.reservationId);
            this.resourceSpecification(model.resourceSpecification);
            this.start(model.start);
            this.state(model.state);
            this.usagePrice(model.usagePrice);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final String getDurationUnitsAsString() {
            return this.durationUnits;
        }

        @Override
        public final Builder durationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
            return this;
        }

        @Override
        public final Builder durationUnits(OfferingDurationUnits durationUnits) {
            this.durationUnits(durationUnits.toString());
            return this;
        }

        public final void setDurationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
        }

        public final String getEnd() {
            return this.end;
        }

        @Override
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        public final Double getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOfferingDescription() {
            return this.offeringDescription;
        }

        @Override
        public final Builder offeringDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
            return this;
        }

        public final void setOfferingDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final String getOfferingTypeAsString() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingType offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getReservationId() {
            return this.reservationId;
        }

        @Override
        public final Builder reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public final void setReservationId(String reservationId) {
            this.reservationId = reservationId;
        }

        public final ReservationResourceSpecification.Builder getResourceSpecification() {
            return this.resourceSpecification != null ? this.resourceSpecification.toBuilder() : null;
        }

        @Override
        public final Builder resourceSpecification(ReservationResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final void setResourceSpecification(ReservationResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        public final String getStart() {
            return this.start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReservationState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Double getUsagePrice() {
            return this.usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        @Override
        public DescribeReservationResponse build() {
            return new DescribeReservationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservationResponse> {
        public Builder arn(String var1);

        public Builder count(Integer var1);

        public Builder currencyCode(String var1);

        public Builder duration(Integer var1);

        public Builder durationUnits(String var1);

        public Builder durationUnits(OfferingDurationUnits var1);

        public Builder end(String var1);

        public Builder fixedPrice(Double var1);

        public Builder name(String var1);

        public Builder offeringDescription(String var1);

        public Builder offeringId(String var1);

        public Builder offeringType(String var1);

        public Builder offeringType(OfferingType var1);

        public Builder region(String var1);

        public Builder reservationId(String var1);

        public Builder resourceSpecification(ReservationResourceSpecification var1);

        default public Builder resourceSpecification(Consumer<ReservationResourceSpecification.Builder> resourceSpecification) {
            return this.resourceSpecification((ReservationResourceSpecification)((ReservationResourceSpecification.Builder)ReservationResourceSpecification.builder().applyMutation(resourceSpecification)).build());
        }

        public Builder start(String var1);

        public Builder state(String var1);

        public Builder state(ReservationState var1);

        public Builder usagePrice(Double var1);
    }
}

