/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.ChannelPlacementGroupState;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateChannelPlacementGroupResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, UpdateChannelPlacementGroupResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateChannelPlacementGroupResponse.getter(UpdateChannelPlacementGroupResponse::arn)).setter(UpdateChannelPlacementGroupResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Channels").getter(UpdateChannelPlacementGroupResponse.getter(UpdateChannelPlacementGroupResponse::channels)).setter(UpdateChannelPlacementGroupResponse.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(UpdateChannelPlacementGroupResponse.getter(UpdateChannelPlacementGroupResponse::clusterId)).setter(UpdateChannelPlacementGroupResponse.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateChannelPlacementGroupResponse.getter(UpdateChannelPlacementGroupResponse::id)).setter(UpdateChannelPlacementGroupResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateChannelPlacementGroupResponse.getter(UpdateChannelPlacementGroupResponse::name)).setter(UpdateChannelPlacementGroupResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Nodes").getter(UpdateChannelPlacementGroupResponse.getter(UpdateChannelPlacementGroupResponse::nodes)).setter(UpdateChannelPlacementGroupResponse.setter(Builder::nodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(UpdateChannelPlacementGroupResponse.getter(UpdateChannelPlacementGroupResponse::stateAsString)).setter(UpdateChannelPlacementGroupResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNELS_FIELD, CLUSTER_ID_FIELD, ID_FIELD, NAME_FIELD, NODES_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateChannelPlacementGroupResponse.memberNameToFieldInitializer();
    private final String arn;
    private final List<String> channels;
    private final String clusterId;
    private final String id;
    private final String name;
    private final List<String> nodes;
    private final String state;

    private UpdateChannelPlacementGroupResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.channels = builder.channels;
        this.clusterId = builder.clusterId;
        this.id = builder.id;
        this.name = builder.name;
        this.nodes = builder.nodes;
        this.state = builder.state;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasChannels() {
        return this.channels != null && !(this.channels instanceof SdkAutoConstructList);
    }

    public final List<String> channels() {
        return this.channels;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasNodes() {
        return this.nodes != null && !(this.nodes instanceof SdkAutoConstructList);
    }

    public final List<String> nodes() {
        return this.nodes;
    }

    public final ChannelPlacementGroupState state() {
        return ChannelPlacementGroupState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannels() ? this.channels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodes() ? this.nodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelPlacementGroupResponse)) {
            return false;
        }
        UpdateChannelPlacementGroupResponse other = (UpdateChannelPlacementGroupResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && this.hasChannels() == other.hasChannels() && Objects.equals(this.channels(), other.channels()) && Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && this.hasNodes() == other.hasNodes() && Objects.equals(this.nodes(), other.nodes()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateChannelPlacementGroupResponse").add("Arn", (Object)this.arn()).add("Channels", this.hasChannels() ? this.channels() : null).add("ClusterId", (Object)this.clusterId()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Nodes", this.hasNodes() ? this.nodes() : null).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Nodes": {
                return Optional.ofNullable(clazz.cast(this.nodes()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("channels", CHANNELS_FIELD);
        map.put("clusterId", CLUSTER_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("nodes", NODES_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelPlacementGroupResponse, T> g) {
        return obj -> g.apply((UpdateChannelPlacementGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private String arn;
        private List<String> channels = DefaultSdkAutoConstructList.getInstance();
        private String clusterId;
        private String id;
        private String name;
        private List<String> nodes = DefaultSdkAutoConstructList.getInstance();
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelPlacementGroupResponse model) {
            super(model);
            this.arn(model.arn);
            this.channels(model.channels);
            this.clusterId(model.clusterId);
            this.id(model.id);
            this.name(model.name);
            this.nodes(model.nodes);
            this.state(model.state);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getChannels() {
            if (this.channels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.channels;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ___listOf__stringCopier.copy(channels);
        }

        @Override
        public final Builder channels(Collection<String> channels) {
            this.channels = ___listOf__stringCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(String ... channels) {
            this.channels(Arrays.asList(channels));
            return this;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getNodes() {
            if (this.nodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nodes;
        }

        public final void setNodes(Collection<String> nodes) {
            this.nodes = ___listOf__stringCopier.copy(nodes);
        }

        @Override
        public final Builder nodes(Collection<String> nodes) {
            this.nodes = ___listOf__stringCopier.copy(nodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(String ... nodes) {
            this.nodes(Arrays.asList(nodes));
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ChannelPlacementGroupState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public UpdateChannelPlacementGroupResponse build() {
            return new UpdateChannelPlacementGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateChannelPlacementGroupResponse> {
        public Builder arn(String var1);

        public Builder channels(Collection<String> var1);

        public Builder channels(String ... var1);

        public Builder clusterId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder nodes(Collection<String> var1);

        public Builder nodes(String ... var1);

        public Builder state(String var1);

        public Builder state(ChannelPlacementGroupState var1);
    }
}

