/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NetworkState {
    CREATING("CREATING"),
    CREATE_FAILED("CREATE_FAILED"),
    ACTIVE("ACTIVE"),
    DELETING("DELETING"),
    IDLE("IDLE"),
    IN_USE("IN_USE"),
    UPDATING("UPDATING"),
    DELETE_FAILED("DELETE_FAILED"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkState> VALUE_MAP;
    private final String value;

    private NetworkState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkState> knownValues() {
        EnumSet<NetworkState> knownValues = EnumSet.allOf(NetworkState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NetworkState.class, NetworkState::toString);
    }
}

